/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.yubico.webauthn.data.AuthenticatorTransport;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.webauthn.storage.EnhancedCredentialRecord;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public final class WebAuthnEncoder {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(WebAuthnEncoder.class);

    private WebAuthnEncoder() {
    }

    public static String serializePublicKeyCredentialOptionsAsJSON(@Nullable PublicKeyCredentialCreationOptions options) {
        if (options != null) {
            try {
                return options.toCredentialsCreateJson();
            }
            catch (JsonProcessingException e) {
                LOG.debug("Unable to serialize PublicKeyCredentialOptions", (Throwable)e);
            }
        }
        return "";
    }

    public static String serializePublicKeyCredentialRequestOptionsAsJSON(@Nullable PublicKeyCredentialRequestOptions options) {
        if (options != null) {
            try {
                return options.toCredentialsGetJson();
            }
            catch (JsonProcessingException e) {
                LOG.debug("Unable to serialize PublicKeyCredentialOptions", (Throwable)e);
            }
        }
        return "";
    }

    @Nonnull
    @NotEmpty
    public static String formatInstant(@Nullable Instant time) {
        return WebAuthnEncoder.formatInstant(time, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mmXXX").withZone(ZoneId.of("UTC")));
    }

    @Nonnull
    @NotEmpty
    public static String formatInstant(@Nullable Instant time, @Nullable String pattern) {
        if (time == null || pattern == null) {
            return "";
        }
        return WebAuthnEncoder.formatInstant(time, DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.of("UTC")));
    }

    @Nonnull
    @NotEmpty
    public static String formatInstant(@Nullable Instant time, @Nullable String pattern, @Nullable String zoneId) {
        if (time == null || pattern == null || zoneId == null) {
            return "";
        }
        try {
            return WebAuthnEncoder.formatInstant(time, DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.of(zoneId)));
        }
        catch (DateTimeException e) {
            return "";
        }
    }

    @Nonnull
    @NotEmpty
    public static String formatInstant(@Nullable Instant time, @Nullable DateTimeFormatter formatter) {
        if (time == null || formatter == null) {
            return "";
        }
        try {
            String isoFormat = formatter.format(time);
            assert (isoFormat != null);
            return isoFormat;
        }
        catch (Exception e) {
            LOG.error("Date time formatting error", (Throwable)e);
            return "";
        }
    }

    @Nonnull
    @NotEmpty
    public static String chooseLatestAndTransform(@Nullable Instant first, @Nullable Instant second) {
        if (first == null && second == null) {
            return "";
        }
        if (first == null && second != null) {
            return WebAuthnEncoder.formatInstant(second);
        }
        if (first != null && second == null) {
            return WebAuthnEncoder.formatInstant(first);
        }
        assert (first != null);
        assert (second != null);
        if (first.isAfter(second)) {
            return WebAuthnEncoder.formatInstant(first);
        }
        return WebAuthnEncoder.formatInstant(second);
    }

    @Nonnull
    public static String formatDiscoverable(@Nullable Optional<Boolean> discoverable) {
        String formatted;
        if (discoverable == null) {
            return "not-set";
        }
        String string = formatted = discoverable.isEmpty() ? "unknown" : Boolean.toString(discoverable.get());
        assert (formatted != null);
        return formatted;
    }

    public static boolean isAuthenticatorMetadataAttached(EnhancedCredentialRecord cred) {
        if (cred == null) {
            return false;
        }
        return !cred.getAuthenticatorMetadata().isEmpty();
    }

    @Nonnull
    public static String formatTransports(@Nullable Set<AuthenticatorTransport> transports) {
        if (transports == null) {
            return "";
        }
        return transports.stream().map(AuthenticatorTransport::getId).collect(Collectors.joining(","));
    }
}

