/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.impl;

import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredential;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.webauthn.context.WebAuthnAuthenticationContext;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafe
public class DefaultUserHandleLookupStrategy
implements Function<ProfileRequestContext, byte[]> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultUserHandleLookupStrategy.class);

    @Override
    public byte[] apply(ProfileRequestContext prc) {
        AuthenticationContext authnCtx = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        if (authnCtx == null) {
            return null;
        }
        WebAuthnAuthenticationContext webAuthnContext = (WebAuthnAuthenticationContext)authnCtx.getSubcontext(WebAuthnAuthenticationContext.class);
        if (webAuthnContext == null) {
            return null;
        }
        PublicKeyCredential assertion = webAuthnContext.getPublicKeyCredentialAssertionResponse();
        if (assertion != null && assertion.getResponse() != null && ((AuthenticatorAssertionResponse)assertion.getResponse()).getUserHandle().isPresent()) {
            this.log.trace("Found userHandle from public key credential assertion");
            return ((ByteArray)((AuthenticatorAssertionResponse)assertion.getResponse()).getUserHandle().get()).getBytes();
        }
        if (webAuthnContext.getUserId() != null) {
            this.log.trace("Found userHandle from userId in authentication context");
            return webAuthnContext.getUserId();
        }
        this.log.trace("Unable to find userHandle from either the assertion or the authentication context");
        return null;
    }
}

