/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.impl;

import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.PublicKeyCredential;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.plugin.authn.webauthn.context.WebAuthnAuthenticationContext;
import net.shibboleth.idp.plugin.authn.webauthn.impl.AbstractWebAuthnAction;
import net.shibboleth.idp.plugin.authn.webauthn.impl.DefaultUserHandleLookupStrategy;
import net.shibboleth.idp.plugin.authn.webauthn.policy.CredentialPolicy;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.EnhancedCredentialRecord;
import net.shibboleth.idp.plugin.authn.webauthn.storage.WebAuthnCredentialRepository;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class CheckCredentialPolicy
extends AbstractWebAuthnAction<WebAuthnAuthenticationContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckCredentialPolicy.class);
    @NonnullBeforeExec
    private PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> assertion;
    @Nonnull
    private Function<ProfileRequestContext, byte[]> userHandleLookupStrategy = new DefaultUserHandleLookupStrategy();
    @Nullable
    private CredentialPolicy credentialPolicy;
    @NonnullAfterInit
    private WebAuthnCredentialRepository repository;
    @NonnullBeforeExec
    private AuthenticationContext authnContext;

    protected CheckCredentialPolicy() {
        super(new ChildContextLookup(WebAuthnAuthenticationContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class)));
    }

    public void setCredentialPolicy(@Nullable CredentialPolicy policy) {
        this.checkSetterPreconditions();
        this.credentialPolicy = policy;
    }

    public void setUserHandleLookupStrategy(Function<ProfileRequestContext, byte[]> strategy) {
        this.checkSetterPreconditions();
        this.userHandleLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"UserHandle lookup strategy can not be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.repository = this.getCredentialRepository();
        if (this.repository == null) {
            throw new ComponentInitializationException("Credential repository can not be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull WebAuthnAuthenticationContext context) {
        if (!super.doPreExecute(profileRequestContext, context)) {
            return false;
        }
        this.assertion = context.getPublicKeyCredentialAssertionResponse();
        if (this.assertion == null) {
            this.log.error("{} Assertion not available in registration context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.authnContext = (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class);
        if (this.authnContext == null) {
            this.log.error("{} Authentication context not available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull WebAuthnAuthenticationContext context) {
        CredentialPolicy localPolicy = this.credentialPolicy;
        if (localPolicy == null) {
            this.log.trace("{} No authenticator policy to apply", (Object)this.getLogPrefix());
            return;
        }
        byte[] userHandleBytes = this.userHandleLookupStrategy.apply(profileRequestContext);
        if (userHandleBytes == null) {
            this.log.trace("{} UserHandle could not be found, policy rejected credential", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"CredentialPolicyRejection");
            return;
        }
        Collection registeredCredentials = context.getExistingCredentials();
        ByteArray userHandle = new ByteArray(userHandleBytes);
        List<EnhancedCredentialRecord> credentials = registeredCredentials.stream().filter(cred -> {
            CredentialRecord credRecord = cred.getCredentialRecord();
            return this.assertion.getId().equals((Object)credRecord.getCredential().getCredentialId()) && userHandle.equals((Object)credRecord.getUserIdentity().getId());
        }).toList();
        if (credentials.isEmpty()) {
            this.log.trace("{} UserHandle '{}' does not have a registered credential, policy rejected credential", (Object)this.getLogPrefix(), (Object)userHandle.getBase64());
            ((AuthenticationErrorContext)this.authnContext.ensureSubcontext(AuthenticationErrorContext.class)).getClassifiedErrors().add("CredentialPolicyRejection");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"CredentialPolicyRejection");
            return;
        }
        if (credentials.size() != 1) {
            this.log.trace("{} Credential ID '{}' for userHandle '{}' has more than one registered credential, policy can not be applied, rejecting", new Object[]{this.getLogPrefix(), this.assertion.getId(), userHandle.getHex()});
            ((AuthenticationErrorContext)this.authnContext.ensureSubcontext(AuthenticationErrorContext.class)).getClassifiedErrors().add("CredentialPolicyRejection");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"CredentialPolicyRejection");
            return;
        }
        EnhancedCredentialRecord credentialToEvaluate = credentials.get(0);
        assert (credentialToEvaluate != null);
        CredentialPolicy.CredentialPolicyOutcome outcome = localPolicy.evaluate(credentialToEvaluate, profileRequestContext);
        if (outcome == CredentialPolicy.CredentialPolicyOutcome.REJECT) {
            this.log.trace("{} CredentialPolicy '{}' has rejected credential '{}'", new Object[]{this.getLogPrefix(), localPolicy.getId(), credentialToEvaluate.getCredentialRecord().getCredentialIdBase64()});
            ((AuthenticationErrorContext)this.authnContext.ensureSubcontext(AuthenticationErrorContext.class)).getClassifiedErrors().add("CredentialPolicyRejection");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"CredentialPolicyRejection");
            return;
        }
        if (outcome == CredentialPolicy.CredentialPolicyOutcome.IGNORE) {
            this.log.trace("{} CredentialPolicy '{}' was not active for credential '{}', accepting", new Object[]{this.getLogPrefix(), localPolicy.getId(), credentialToEvaluate.getCredentialRecord().getCredentialIdBase64()});
            return;
        }
        this.log.debug("{} CredentialPolicy '{}' accepted credential '{}'", new Object[]{this.getLogPrefix(), localPolicy.getId(), credentialToEvaluate.getCredentialRecord().getCredentialIdBase64()});
    }
}

