/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage;

import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.data.ByteArray;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;

@ThreadSafe
public interface WebAuthnCredentialRepository
extends CredentialRepository {
    @Nonnull
    @NonnullElements
    @NotLive
    public Set<CredentialRecord> getRegistrationsByUsername(@Nonnull String var1);

    public boolean addRegistrationByUsername(@Nonnull String var1, @Nonnull CredentialRecord var2);

    public boolean updateSignatureCounter(@Nonnull String var1, @Nonnull ByteArray var2, long var3);

    @Nonnull
    public Optional<CredentialRecord> getRegistrationByUsernameAndCredentialId(@Nonnull String var1, @Nonnull ByteArray var2);

    public Optional<CredentialRecord> getRegistrationByUserHandleAndCredentialId(@Nonnull ByteArray var1, @Nonnull ByteArray var2);

    public boolean removeRegistrationByUsername(@Nonnull String var1, @Nonnull CredentialRecord var2);

    public int removeRegistrationByCredentialId(@Nonnull ByteArray var1);

    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<CredentialRecord> getAllRegistrations();

    public boolean removeRegistrationByUsernameAndCredentialId(@Nonnull String var1, @Nonnull ByteArray var2);

    default public boolean updateLastUsedTime(@Nonnull String username, @Nonnull ByteArray credentialId, @Nonnull Instant lastUsedTime) {
        return false;
    }

    default public boolean updateNickname(@Nonnull String username, @Nonnull ByteArray credentialId, @Nonnull String nickname) {
        return false;
    }
}

