/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.storage;

import com.yubico.fido.metadata.MetadataBLOBPayloadEntry;
import com.yubico.fido.metadata.MetadataStatement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.webauthn.metadata.AaguidEntry;
import net.shibboleth.idp.plugin.authn.webauthn.storage.CredentialRecord;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.NonnullSupplier;

public class EnhancedCredentialRecord {
    @Nonnull
    private final CredentialRecord credentialRecord;
    @Nonnull
    @Unmodifiable
    @NonnullElements
    @NotLive
    private Set<MetadataBLOBPayloadEntry> authenticatorMetadata;
    @Nullable
    private AaguidEntry aaguidMetadata;
    @Nonnull
    @Unmodifiable
    @NonnullElements
    @NotLive
    private List<String> labels;

    public EnhancedCredentialRecord(@Nonnull CredentialRecord credential) {
        this.credentialRecord = (CredentialRecord)Constraint.isNotNull((Object)credential, (String)"Credential can not be null");
        this.authenticatorMetadata = CollectionSupport.emptySet();
        this.labels = CollectionSupport.emptyList();
    }

    @Nonnull
    public CredentialRecord getCredentialRecord() {
        return this.credentialRecord;
    }

    public void setAuthenticatorMetadata(@Nullable Set<MetadataBLOBPayloadEntry> metadata) {
        if (metadata != null) {
            this.authenticatorMetadata = CollectionSupport.copyToSet((Collection)((Collection)((NonnullSupplier)metadata.stream().filter(Objects::nonNull).collect(CollectionSupport.nonnullCollector(Collectors.toSet()))).get()));
        }
    }

    @Nonnull
    @Unmodifiable
    @NonnullElements
    @NotLive
    public Set<MetadataBLOBPayloadEntry> getAuthenticatorMetadata() {
        return this.authenticatorMetadata;
    }

    public void setAaguidMetadata(@Nullable AaguidEntry metadata) {
        if (metadata != null) {
            this.aaguidMetadata = metadata;
        }
    }

    public void setLabels(@Nonnull List<String> labelsIn) {
        this.labels = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(labelsIn, (String)"labels can not be null")));
    }

    @Nonnull
    @Unmodifiable
    @NonnullElements
    @NotLive
    public List<String> getLabels() {
        return this.labels;
    }

    @Nullable
    public String getAuthenticatorDescription() {
        if (!this.authenticatorMetadata.isEmpty()) {
            Optional<Optional> descriptionFound = this.authenticatorMetadata.stream().filter(mtd -> mtd.getMetadataStatement().isPresent()).map(mtd -> ((MetadataStatement)mtd.getMetadataStatement().get()).getDescription()).findFirst();
            if (descriptionFound.isEmpty() || descriptionFound.get().isEmpty() || ((String)descriptionFound.get().get()).isEmpty()) {
                return null;
            }
            return (String)descriptionFound.get().get();
        }
        if (this.aaguidMetadata != null) {
            return this.aaguidMetadata.getName();
        }
        return null;
    }

    @Nullable
    public String getIcon() {
        if (!this.authenticatorMetadata.isEmpty()) {
            Optional<Optional> iconFound = this.authenticatorMetadata.stream().filter(mtd -> mtd.getMetadataStatement().isPresent()).map(mtd -> ((MetadataStatement)mtd.getMetadataStatement().get()).getIcon()).findFirst();
            if (iconFound.isEmpty() || iconFound.get().isEmpty() || ((String)iconFound.get().get()).isEmpty()) {
                return null;
            }
            return (String)iconFound.get().get();
        }
        if (this.aaguidMetadata != null) {
            return this.aaguidMetadata.getIconLight();
        }
        return null;
    }
}

