/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.admin.impl;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;

public class MultiPredicateAccessPredicate
extends AbstractIdentifiableInitializableComponent
implements Predicate<ProfileRequestContext> {
    @Nonnull
    @NotEmpty
    @NotLive
    @Unmodifiable
    private final List<Predicate<ProfileRequestContext>> predicates;

    public MultiPredicateAccessPredicate(@Nonnull @NotEmpty List<Predicate<ProfileRequestContext>> predicateList) {
        this.predicates = (List)Constraint.isNotNull((Object)CollectionSupport.copyToList(predicateList), (String)"Predicate list can not be null");
    }

    @Override
    public boolean test(ProfileRequestContext prc) {
        for (Predicate<ProfileRequestContext> predicate : this.predicates) {
            if (predicate.test(prc)) continue;
            return false;
        }
        return true;
    }
}

