/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.admin.impl;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.webauthn.context.WebAuthnRegistrationContext;
import net.shibboleth.idp.plugin.authn.webauthn.impl.AbstractWebAuthnAction;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ExtractNicknameFromFormRequest
extends AbstractWebAuthnAction<WebAuthnRegistrationContext> {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_NICKNAME_FIELD_NAME = "credentialNickname";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractNicknameFromFormRequest.class);
    @Nonnull
    @NotEmpty
    private String credentialNicknameParameterName = "credentialNickname";
    @Nonnull
    @NotEmpty
    private String noCredentialNicknameEventId = "InvalidRegistration";

    public ExtractNicknameFromFormRequest() {
        super(new ChildContextLookup(WebAuthnRegistrationContext.class));
    }

    public void setCredentialNicknameParameterName(@Nonnull @NotEmpty String field) {
        this.checkSetterPreconditions();
        this.credentialNicknameParameterName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)field), (String)"Nickname parameter can not be null or empty");
    }

    public void setNoCredentialNicknameEventId(@Nonnull @NotEmpty String eventId) {
        this.checkSetterPreconditions();
        this.noCredentialNicknameEventId = Constraint.isNotEmpty((String)eventId, (String)"NoCredentialsEventId can not be null or empty");
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull WebAuthnRegistrationContext context) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAdminAction");
            return;
        }
        String credNickname = request.getParameter(this.credentialNicknameParameterName);
        this.log.trace("{} Credential nickname is '{}'", (Object)this.getLogPrefix(), (Object)credNickname);
        if (StringSupport.trimOrNull((String)credNickname) == null && context.isNicknameRequired()) {
            this.log.debug("{} Credential nickname is not in the request but is required", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)this.noCredentialNicknameEventId);
            return;
        }
        context.setCredentialNickname(credNickname);
    }
}

