/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.webauthn.admin.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.webauthn.context.WebAuthnRegistrationContext;
import net.shibboleth.idp.plugin.authn.webauthn.impl.AbstractWebAuthnAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddNicknameRequired
extends AbstractWebAuthnAction<WebAuthnRegistrationContext> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddNicknameRequired.class);
    @NonnullAfterInit
    private Predicate<ProfileRequestContext> nicknameRequiredPredicate = PredicateSupport.alwaysTrue();

    protected AddNicknameRequired() {
        super(new ChildContextLookup(WebAuthnRegistrationContext.class));
    }

    public void setNicknameRequiredPredicate(Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.nicknameRequiredPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"isNicknameRequiredPredicate can not be null");
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.nicknameRequiredPredicate == null) {
            throw new ComponentInitializationException("isNicknameRequiredPredicate can not be null");
        }
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull WebAuthnRegistrationContext context) {
        boolean nicknameRequired = this.nicknameRequiredPredicate.test(profileRequestContext);
        this.log.debug("{} Nickname collection {}", (Object)this.getLogPrefix(), (Object)(nicknameRequired ? "enabled" : "disabled"));
        context.setNicknameRequired(nicknameRequired);
    }
}

