/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.sdk.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientFactory;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.sdk.impl.DuoSDKClientAdaptor;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.StringSupport;

@ThreadSafe
public final class DuoSDKClientFactory
extends AbstractInitializableComponent
implements DuoOIDCClientFactory {
    @Nullable
    @GuardedBy(value="this")
    @NonnullElements
    @Unmodifiable
    private List<String> caCerts;
    @Nullable
    @GuardedBy(value="this")
    @NotEmpty
    private String proxyHost;
    @Nullable
    @GuardedBy(value="this")
    private Integer proxyPort;

    public synchronized void setCaCerts(@Nullable List<String> certs) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.caCerts = certs != null ? List.copyOf(StringSupport.normalizeStringCollection(certs)) : null;
    }

    @Nullable
    @NonnullElements
    @Unmodifiable
    private synchronized List<String> getCaCerts() {
        this.checkComponentActive();
        return this.caCerts;
    }

    public synchronized void setProxyHost(@Nullable @NotEmpty String host) {
        this.checkSetterPreconditions();
        this.proxyHost = host;
    }

    @Nullable
    @NotEmpty
    private synchronized String getProxyHost() {
        this.checkComponentActive();
        return this.proxyHost;
    }

    public synchronized void setProxyPort(@Nullable Integer port) {
        this.checkSetterPreconditions();
        this.proxyPort = port;
    }

    @Nullable
    private synchronized Integer getProxyPort() {
        this.checkComponentActive();
        return this.proxyPort;
    }

    @Nonnull
    public DuoOIDCClient createInstance(@Nonnull DuoOIDCIntegration integration) throws DuoClientException {
        String localProxyHost = StringSupport.trimOrNull((String)this.getProxyHost());
        Integer localProxyPort = this.getProxyPort();
        if (localProxyPort != null && localProxyHost != null) {
            return new DuoSDKClientAdaptor(integration, this.getCaCerts(), localProxyHost, localProxyPort);
        }
        return new DuoSDKClientAdaptor(integration, this.getCaCerts());
    }
}

