/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.idp.authn.duo.DuoIntegration;
import net.shibboleth.idp.plugin.authn.duo.DuoException;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;

@ThreadSafe
public final class DuoSupport {
    public static final DateTimeFormatter RFC_2822_DATE_FORMAT = DateTimeFormatter.ofPattern("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z");

    private DuoSupport() {
    }

    private static String canonRequest(@Nonnull ClassicRequestBuilder request, @Nonnull String date, int sigVersion) {
        URI uri = request.getUri();
        Object canon = "";
        if (sigVersion == 2) {
            canon = (String)canon + date + "\n";
        }
        canon = (String)canon + request.getMethod().toUpperCase() + "\n";
        canon = (String)canon + uri.getHost().toLowerCase() + "\n";
        canon = (String)canon + uri.getPath() + "\n";
        List parms = request.getParameters();
        if (parms != null) {
            canon = (String)canon + DuoSupport.createQueryString(parms);
        }
        return canon;
    }

    private static String createQueryString(@Nonnull List<NameValuePair> params) {
        ArrayList<CallSite> args = new ArrayList<CallSite>();
        Collections.sort(params, new Comparator<NameValuePair>(){

            @Override
            public int compare(NameValuePair nvp1, NameValuePair nvp2) {
                return nvp1.getName().compareTo(nvp2.getName());
            }
        });
        Escaper escaper = UrlEscapers.urlFormParameterEscaper();
        for (NameValuePair nvp : params) {
            String name = escaper.escape(nvp.getName()).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            String value = escaper.escape(nvp.getValue()).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            args.add((CallSite)((Object)(name + "=" + value)));
        }
        return StringSupport.listToStringValue(args, (String)"&");
    }

    @NotEmpty
    public static void signRequest(@Nonnull ClassicRequestBuilder request, @Nonnull DuoIntegration duo) throws InvalidKeyException, NoSuchAlgorithmException, EncodingException {
        String ikey = duo.getIntegrationKey();
        String skey = duo.getSecretKey();
        int sigVersion = 2;
        String date = RFC_2822_DATE_FORMAT.format(ZonedDateTime.now());
        assert (date != null);
        String canon = DuoSupport.canonRequest(request, date, 2);
        SecretKeySpec key = new SecretKeySpec(skey.getBytes(), "HmacSHA1");
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(key);
        byte[] raw = mac.doFinal(canon.getBytes());
        String sig = Hex.encodeHexString((byte[])raw);
        String auth = ikey + ":" + sig;
        String header = "Basic " + Base64Support.encode((byte[])auth.getBytes(), (boolean)false);
        request.addHeader("Authorization", header);
        request.addHeader("Date", date);
    }

    @Nonnull
    static String generateNonce(@Nonnull Integer length) {
        Constraint.isGreaterThan((int)22, (int)length, (String)"Nonce must be at least 22 characters");
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length) {
            sb.append(Integer.toHexString(secureRandom.nextInt()));
        }
        return sb.toString().substring(0, length);
    }

    @Nonnull
    static String generateState(@Nonnull String nonce, @Nonnull String key) {
        Constraint.isNotNull((Object)nonce, (String)"Nonce Hex key can not be null");
        Constraint.isNotNull((Object)key, (String)"Webflow execution key can not be null");
        String keyHex = Hex.encodeHexString((byte[])key.getBytes());
        return nonce + "." + keyHex;
    }

    @Nonnull
    static String extractKeyFromState(@Nonnull String state) throws DuoException {
        Constraint.isNotNull((Object)state, (String)"State can not be null");
        String[] stateSplit = state.split("\\.");
        if (stateSplit.length != 2) {
            throw new DuoException("State does not contain the key component");
        }
        String hexKey = stateSplit[1];
        try {
            return new String(Hex.decodeHex((String)hexKey));
        }
        catch (DecoderException e) {
            throw new DuoException("Can not hex decode key", (Throwable)e);
        }
    }

    @Nonnull
    static String extractNonceFromState(@Nonnull String state) throws DuoException {
        Constraint.isNotNull((Object)state, (String)"State can not be null");
        String[] stateSplit = state.split("\\.");
        if (stateSplit.length != 2) {
            throw new DuoException("State does not contain the nonce component");
        }
        return stateSplit[0];
    }
}

