/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.admin.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.authn.duo.PasswordlessCookieManager;
import net.shibboleth.idp.plugin.authn.duo.admin.impl.AdminFlowDescriptor;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.AccessControlService;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ManagePasswordlessCookie
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String USERNAME_FIELD_NAME = "j_username";
    @Nonnull
    @NotEmpty
    public static final String OPERATION_FIELD_NAME = "operation";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ManagePasswordlessCookie.class);
    @NonnullAfterInit
    private AccessControlService accessControlService;
    @NonnullAfterInit
    private PasswordlessCookieManager cookieManager;
    @NonnullBeforeExec
    private String currentUsername;

    public void setAccessControlService(@Nonnull AccessControlService service) {
        this.checkSetterPreconditions();
        this.accessControlService = (AccessControlService)Constraint.isNotNull((Object)service, (String)"AccessControlService cannot be null");
    }

    public void setPasswordlessCookieManager(@Nullable PasswordlessCookieManager manager) {
        this.checkSetterPreconditions();
        this.cookieManager = (PasswordlessCookieManager)Constraint.isNotNull((Object)manager, (String)"PasswordlessCookieManager cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.accessControlService == null) {
            throw new ComponentInitializationException("AccessControlService cannot be null");
        }
        if (this.cookieManager == null) {
            throw new ComponentInitializationException("PasswordlessCookieManager cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} No HttpServletRequest available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        SubjectContext subjectCtx = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class);
        String string = this.currentUsername = subjectCtx != null ? subjectCtx.getPrincipalName() : null;
        if (this.currentUsername == null) {
            this.log.warn("{} No current username available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpServletRequest request = this.ensureHttpServletRequest();
        String operation = request.getParameter(OPERATION_FIELD_NAME);
        if ("clear".equals(operation)) {
            this.cookieManager.clearCookie();
        } else if ("optout".equals(operation)) {
            if (this.cookieManager.writeCookie(null)) {
                this.log.debug("{} Created passwordless cookie for opt-out", (Object)this.getLogPrefix());
            } else {
                this.log.warn("{} Failed to create passwordless cookie for opt-out", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        } else if ("optin".equals(operation)) {
            String targetName = request.getParameter(USERNAME_FIELD_NAME);
            if (targetName == null) {
                targetName = this.currentUsername;
            } else if (!targetName.equals(this.currentUsername) && !this.isAdminAllowed(profileRequestContext, targetName)) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
                return;
            }
            this.log.debug("{} Creating passwordless cookie for username '{}'", (Object)this.getLogPrefix(), (Object)targetName);
            if (!this.cookieManager.writeCookie(targetName)) {
                this.log.warn("{} Failed to create passwordless cookie for username '{}'", (Object)this.getLogPrefix(), (Object)targetName);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
    }

    private boolean isAdminAllowed(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String username) {
        AdminFlowDescriptor duo;
        String policy;
        ProfileConfiguration profileConfiguration;
        RelyingPartyContext rpCtx = (RelyingPartyContext)profileRequestContext.getSubcontext(RelyingPartyContext.class);
        if (rpCtx != null && (profileConfiguration = rpCtx.getProfileConfig()) instanceof AdminFlowDescriptor && (policy = (duo = (AdminFlowDescriptor)profileConfiguration).getAdminPolicyName(profileRequestContext)) != null) {
            this.log.debug("{} Checking for admin access to Duo passwordless cookie with policy {}", (Object)this.getLogPrefix(), (Object)policy);
            boolean result = this.accessControlService.getInstance(policy).checkAccess((ServletRequest)this.ensureHttpServletRequest(), "write", username);
            if (!result) {
                this.log.warn("{} Access to passwordless cookie for username '{}' denied", (Object)this.getLogPrefix(), (Object)username);
            }
            return result;
        }
        this.log.warn("{} Unable to obtain admin access policy to use", (Object)this.getLogPrefix());
        return false;
    }
}

