/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.model;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.duo.model.U2ftoken;
import net.shibboleth.idp.plugin.authn.duo.model.WebAuthnCredential;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public final class User {
    public static final long serialVersionUID = 8122423604710803224L;
    @JsonProperty(value="created")
    @Nullable
    private final Integer created;
    @JsonProperty(value="email")
    @Nullable
    private final String email;
    @JsonProperty(value="firstname")
    @Nullable
    private final String firstname;
    @JsonProperty(value="is_enrolled")
    @Nullable
    private final Boolean enrolled;
    @JsonProperty(value="last_directory_sync")
    @Nullable
    private final Object lastDirectorySync;
    @JsonProperty(value="last_login")
    @Nullable
    private final Integer lastLogin;
    @JsonProperty(value="lastname")
    @Nullable
    private final String lastname;
    @JsonProperty(value="lockout_reason")
    @Nullable
    private final String lockoutReason;
    @JsonProperty(value="notes")
    @Nullable
    private final String notes;
    @JsonProperty(value="realname")
    @Nullable
    private final String realname;
    @JsonProperty(value="status")
    @Nullable
    private final String status;
    @JsonProperty(value="u2ftokens")
    @Nonnull
    @NotLive
    @Unmodifiable
    private final List<U2ftoken> u2ftokens;
    @JsonProperty(value="user_id")
    @Nullable
    private final String userId;
    @JsonProperty(value="username")
    @Nullable
    private final String username;
    @JsonProperty(value="webauthncredentials")
    @Nonnull
    @NotLive
    @Unmodifiable
    private final List<WebAuthnCredential> webAuthnCredentials;
    @JsonIgnore
    @Nonnull
    @NotLive
    @Unmodifiable
    private final Map<String, Object> additionalProperties;

    private User(Builder builder) {
        this.created = builder.created;
        this.email = builder.email;
        this.firstname = builder.firstname;
        this.enrolled = builder.enrolled;
        this.lastDirectorySync = builder.lastDirectorySync;
        this.lastLogin = builder.lastLogin;
        this.lastname = builder.lastname;
        this.lockoutReason = builder.lockoutReason;
        this.notes = builder.notes;
        this.realname = builder.realname;
        this.status = builder.status;
        this.u2ftokens = builder.u2ftokens;
        this.userId = builder.userId;
        this.username = builder.username;
        this.webAuthnCredentials = builder.webAuthnCredentials;
        this.additionalProperties = CollectionSupport.copyToMap(builder.additionalProperties);
    }

    @JsonProperty(value="created")
    @Nullable
    public Integer getCreated() {
        return this.created;
    }

    @JsonProperty(value="email")
    @Nullable
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="firstname")
    @Nullable
    public Object getFirstname() {
        return this.firstname;
    }

    @JsonProperty(value="is_enrolled")
    @Nullable
    public Boolean isEnrolled() {
        return this.enrolled;
    }

    @JsonProperty(value="last_directory_sync")
    @Nullable
    public Object getLastDirectorySync() {
        return this.lastDirectorySync;
    }

    @JsonProperty(value="last_login")
    @Nullable
    public Integer getLastLogin() {
        return this.lastLogin;
    }

    @JsonProperty(value="lastname")
    @Nullable
    public Object getLastname() {
        return this.lastname;
    }

    @JsonProperty(value="lockout_reason")
    @Nullable
    public Object getLockoutReason() {
        return this.lockoutReason;
    }

    @JsonProperty(value="notes")
    @Nullable
    public String getNotes() {
        return this.notes;
    }

    @JsonProperty(value="realname")
    @Nullable
    public String getRealname() {
        return this.realname;
    }

    @JsonProperty(value="status")
    @Nullable
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="u2ftokens")
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<U2ftoken> getU2ftokens() {
        return this.u2ftokens;
    }

    @JsonProperty(value="user_id")
    @Nullable
    public String getUserId() {
        return this.userId;
    }

    @JsonProperty(value="username")
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="webauthncredentials")
    @Nonnull
    @NotLive
    @Unmodifiable
    public List<WebAuthnCredential> getWebAuthnCredentials() {
        return this.webAuthnCredentials;
    }

    @JsonIgnore
    @Nonnull
    @NotLive
    @Unmodifiable
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(buildMethodName="build", withPrefix="with")
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        @Nullable
        private Integer created;
        @Nullable
        private String email;
        @Nullable
        private String firstname;
        @Nullable
        private Boolean enrolled;
        @Nullable
        private Object lastDirectorySync;
        @Nullable
        private Integer lastLogin;
        @Nullable
        private String lastname;
        @Nullable
        private String lockoutReason;
        @Nullable
        private String notes;
        @Nullable
        private String realname;
        @Nullable
        private String status;
        @Nonnull
        private List<U2ftoken> u2ftokens;
        @Nullable
        private String userId;
        @Nullable
        private String username;
        @Nonnull
        private List<WebAuthnCredential> webAuthnCredentials = CollectionSupport.emptyList();
        @Nonnull
        private final Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
            this.u2ftokens = CollectionSupport.emptyList();
        }

        @JsonProperty(value="created")
        public Builder withCreated(@Nullable Integer createdAt) {
            this.created = createdAt;
            return this;
        }

        @JsonProperty(value="email")
        public Builder withEmail(@Nullable String emailIn) {
            this.email = emailIn;
            return this;
        }

        @JsonProperty(value="firstname")
        public Builder withFirstname(@Nullable String firstnameIn) {
            this.firstname = firstnameIn;
            return this;
        }

        @JsonProperty(value="is_enrolled")
        public Builder withIsEnrolled(@Nullable Boolean isEnrolled) {
            this.enrolled = isEnrolled;
            return this;
        }

        @JsonProperty(value="last_directory_sync")
        public Builder withLastDirectorySync(@Nullable Object dirSync) {
            this.lastDirectorySync = dirSync;
            return this;
        }

        @JsonProperty(value="last_login")
        public Builder withLastLogin(@Nullable Integer lastLoginAt) {
            this.lastLogin = lastLoginAt;
            return this;
        }

        @JsonProperty(value="lastname")
        public Builder withLastname(@Nullable String lastnameIn) {
            this.lastname = lastnameIn;
            return this;
        }

        @JsonProperty(value="lockout_reason")
        public Builder withLockoutReason(@Nullable String lockoutReasonIn) {
            this.lockoutReason = lockoutReasonIn;
            return this;
        }

        @JsonProperty(value="notes")
        public Builder withNotes(@Nullable String notesIn) {
            this.notes = notesIn;
            return this;
        }

        @JsonProperty(value="realname")
        public Builder withRealname(@Nullable String realnameIn) {
            this.realname = realnameIn;
            return this;
        }

        @JsonProperty(value="status")
        public Builder withStatus(@Nullable String statusIn) {
            this.status = statusIn;
            return this;
        }

        @JsonProperty(value="u2ftokens")
        public Builder withU2ftokens(@Nullable List<U2ftoken> tokens) {
            if (tokens != null) {
                this.u2ftokens = CollectionSupport.copyToList(tokens);
            }
            return this;
        }

        @JsonProperty(value="user_id")
        public Builder withUserId(@Nullable String id) {
            this.userId = id;
            return this;
        }

        @JsonProperty(value="username")
        public Builder withUsername(@Nullable String uname) {
            this.username = uname;
            return this;
        }

        @JsonProperty(value="webauthncredentials")
        public Builder withWebAuthnCredentials(@Nullable List<WebAuthnCredential> credentials) {
            if (credentials != null) {
                this.webAuthnCredentials = CollectionSupport.copyToList(credentials);
            }
            return this;
        }

        @JsonAnySetter
        public Builder withAdditionalProperty(@Nonnull String name, @Nullable Object value) {
            if (value != null) {
                this.additionalProperties.put(name, value);
            }
            return this;
        }

        public User build() {
            return new User(this);
        }
    }
}

