/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.nimbus.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import java.security.SecureRandom;
import java.text.ParseException;
import java.time.Duration;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.oidc.security.JWSAssemblyUtils;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.logic.Constraint;

@ThreadSafe
public final class NimbusClientSupport {
    private NimbusClientSupport() {
    }

    @Nonnull
    static String generateJWTId(@Nonnull Integer length) {
        Constraint.isNotNull((Object)length, (String)"JWT length can not be null");
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length) {
            sb.append(Integer.toHexString(secureRandom.nextInt()));
        }
        return sb.toString().substring(0, length);
    }

    @Nonnull
    static String createJWSRequestObject(@Nonnull @NotEmpty String clientID, @Nonnull @NotEmpty String redirectURI, @Nonnull @NotEmpty String secret, @Nonnull @NotEmpty String state, @Nonnull @NotEmpty String username) throws DuoClientException {
        Constraint.isNotEmpty((String)clientID, (String)"ClientID can not be null or empty");
        Constraint.isNotEmpty((String)redirectURI, (String)"RedirectURI can not be null or empty");
        Constraint.isNotEmpty((String)state, (String)"State can not be null or empty");
        Constraint.isNotEmpty((String)username, (String)"username can not be null or empty");
        Date expiration = new Date();
        expiration.setTime(expiration.getTime() + Duration.ofHours(1L).toMillis());
        try {
            JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().expirationTime(expiration).claim("scope", (Object)"openid").claim("client_id", (Object)clientID).claim("redirect_uri", (Object)redirectURI).claim("state", (Object)state).claim("duo_uname", (Object)username).claim("response_type", (Object)"code").build();
            return JWSAssemblyUtils.assembleMacJwsAsString((JWSAlgorithm)JWSAlgorithm.HS512, (JWTClaimsSet)claimsSet, (byte[])JWSAssemblyUtils.getSecretBytes((String)secret));
        }
        catch (JOSEException | ParseException | EncodingException e) {
            throw new DuoClientException(e);
        }
    }

    @Nonnull
    static String createJWS(@Nonnull String aud, @Nonnull String clientID, @Nonnull String secret) throws DuoClientException {
        Constraint.isNotNull((Object)clientID, (String)"Duo clientId can not be null");
        Constraint.isNotNull((Object)secret, (String)"Duo secret can not be null");
        Constraint.isNotNull((Object)aud, (String)"Audience can not be null");
        Date expiration = new Date();
        expiration.setTime(expiration.getTime() + Duration.ofHours(1L).toMillis());
        try {
            JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().expirationTime(expiration).issuer(clientID).subject(clientID).audience(aud).jwtID(NimbusClientSupport.generateJWTId(32)).build();
            return JWSAssemblyUtils.assembleMacJwsAsString((JWSAlgorithm)JWSAlgorithm.HS512, (JWTClaimsSet)claimsSet, (byte[])JWSAssemblyUtils.getSecretBytes((String)secret));
        }
        catch (JOSEException | ParseException | EncodingException e) {
            throw new DuoClientException(e);
        }
    }
}

