/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.duo.nimbus.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.duo.DuoClientException;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClient;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCClientFactory;
import net.shibboleth.idp.plugin.authn.duo.DuoOIDCIntegration;
import net.shibboleth.idp.plugin.authn.duo.nimbus.impl.NimbusClient;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;

@ThreadSafe
public final class NimbusClientFactory
extends AbstractInitializableComponent
implements DuoOIDCClientFactory {
    @GuardedBy(value="this")
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    @GuardedBy(value="this")
    private HttpClientSecurityParameters httpClientSecurityParameters;
    @GuardedBy(value="this")
    @NonnullAfterInit
    private ObjectMapper objectMapper;

    @Nonnull
    public DuoOIDCClient createInstance(@Nonnull DuoOIDCIntegration integration) throws DuoClientException {
        return new NimbusClient(integration, this.getHttpClient(), this.getHttpClientSecurityParameters(), this.getObjectMapper());
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getHttpClient() == null) {
            throw new ComponentInitializationException("HttpClient cannot be null");
        }
        if (this.getObjectMapper() == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
    }

    @NonnullAfterInit
    private synchronized HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Nullable
    private synchronized HttpClientSecurityParameters getHttpClientSecurityParameters() {
        return this.httpClientSecurityParameters;
    }

    @NonnullAfterInit
    private synchronized ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public synchronized void setHttpClient(@Nonnull HttpClient client) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HTTP client cannot be null");
    }

    public synchronized void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.httpClientSecurityParameters = params;
    }

    public synchronized void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.ifInitializedThrowUnmodifiabledComponentException();
        this.ifDestroyedThrowDestroyedComponentException();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"Object mapper cannot be null");
    }
}

