/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.messaging.handler.AbstractMessageHandler;

public abstract class AbstractHttpServletRequestMessageHandler
extends AbstractMessageHandler {
    private boolean checkDuringInit = true;
    @NonnullAfterInit
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;

    public boolean isCheckDuringInit() {
        return this.checkDuringInit;
    }

    public void setCheckDuringInit(boolean flag) {
        this.checkSetterPreconditions();
        this.checkDuringInit = flag;
    }

    @NonnullAfterInit
    public HttpServletRequest getHttpServletRequest() {
        if (this.httpServletRequestSupplier == null) {
            return null;
        }
        return (HttpServletRequest)this.httpServletRequestSupplier.get();
    }

    @NonnullAfterInit
    public NonnullSupplier<HttpServletRequest> getHttpServletRequestSupplier() {
        return this.httpServletRequestSupplier;
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpServletRequestSupplier = requestSupplier;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.isCheckDuringInit() && this.getHttpServletRequest() == null) {
            throw new ComponentInitializationException("HttpServletRequest cannot be null");
        }
    }
}

