/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.servlet.impl;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.spring.servlet.ChainableFilter;

public class CharacterEncodingFilter
extends org.springframework.web.filter.CharacterEncodingFilter
implements ChainableFilter {
    @Nonnull
    private Predicate<ServletRequest> activationCondition = PredicateSupport.alwaysTrue();

    @Nonnull
    public Predicate<ServletRequest> getActivationCondition() {
        return this.activationCondition;
    }

    public void setActivationCondition(@Nonnull Predicate<ServletRequest> condition) {
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Run condition cannot be null");
    }

    @Override
    public int getOrder() {
        return ChainableFilter.FilterOrder.NEUTRAL.getValue();
    }

    protected void doFilterInternal(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain filterChain) throws ServletException, IOException {
        if (!this.activationCondition.test((ServletRequest)request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        super.doFilterInternal(request, response, filterChain);
    }
}

