/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.interceptor;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.ProfileInterceptorContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractProfileInterceptorAction
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractProfileInterceptorAction.class);
    @Nonnull
    private Function<ProfileRequestContext, ProfileInterceptorContext> interceptorContextlookupStrategy = new ChildContextLookup(ProfileInterceptorContext.class, true);
    @NonnullBeforeExec
    private ProfileInterceptorContext profileInterceptorContext;

    public void setLookupStrategy(@Nonnull Function<ProfileRequestContext, ProfileInterceptorContext> strategy) {
        this.checkSetterPreconditions();
        this.interceptorContextlookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy cannot be null");
    }

    @Nonnull
    private ProfileInterceptorContext getProfileInterceptorContext() {
        assert (this.isPreExecuteCalled());
        return this.profileInterceptorContext;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.profileInterceptorContext = this.interceptorContextlookupStrategy.apply(profileRequestContext);
        ProfileInterceptorContext pic = this.profileInterceptorContext;
        if (pic == null) {
            this.log.error("{} Unable to create or locate profile interceptor context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return this.doPreExecute(profileRequestContext, pic) && super.doPreExecute(profileRequestContext);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
        return true;
    }

    protected final void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.doExecute(profileRequestContext, this.getProfileInterceptorContext());
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ProfileInterceptorContext interceptorContext) {
    }
}

