/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.io.Hex;

public final class SchemaUtils {
    private SchemaUtils() {
    }

    public static String[] parseDescriptors(String descrs) {
        if (descrs.contains("'")) {
            String[] quotedDescr = descrs.split(" ");
            String[] s = new String[quotedDescr.length];
            for (int i = 0; i < s.length; ++i) {
                s[i] = SchemaUtils.parseQDString(quotedDescr[i].substring(1, quotedDescr[i].length() - 1).trim());
            }
            return s;
        }
        return new String[]{SchemaUtils.parseQDString(descrs)};
    }

    public static String parseQDString(String value) {
        if (value == null || !value.contains("\\")) {
            return value;
        }
        int len = value.length();
        StringBuilder sb = new StringBuilder(len);
        StringBuilder hexValue = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            boolean appendHex = false;
            boolean appendValue = false;
            if (c == '\\' && i + 2 < len && Hex.isValidChar(value.charAt(i + 1)) && Hex.isValidChar(value.charAt(i + 2))) {
                hexValue.append(value.charAt(++i)).append(value.charAt(++i));
                if (i + 1 == len) {
                    appendHex = true;
                }
            } else {
                appendHex = hexValue.length() > 0;
                appendValue = true;
            }
            if (appendHex) {
                sb.append(LdapUtils.utf8Encode(LdapUtils.hexDecode(hexValue.toString().toCharArray())));
                hexValue.setLength(0);
            }
            if (!appendValue) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] parseOIDs(String oids) {
        if (oids.contains("$")) {
            String[] s = oids.split("\\$");
            for (int i = 0; i < s.length; ++i) {
                s[i] = s[i].trim();
            }
            return s;
        }
        return new String[]{oids};
    }

    public static int[] parseNumbers(String numbers) {
        String[] s = numbers.split(" ");
        int[] i = new int[s.length];
        for (int j = 0; j < i.length; ++j) {
            i[j] = Integer.parseInt(s[j].trim());
        }
        return i;
    }

    public static String formatDescriptors(String ... descrs) {
        StringBuilder sb = new StringBuilder();
        if (descrs.length == 1) {
            sb.append("'");
            SchemaUtils.encodeDescriptor(sb, descrs[0]);
            sb.append("' ");
        } else {
            sb.append("( ");
            for (String descr : descrs) {
                sb.append("'");
                SchemaUtils.encodeDescriptor(sb, descr);
                sb.append("' ");
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    private static void encodeDescriptor(StringBuilder sb, String descr) {
        int len = descr.length();
        for (int i = 0; i < len; ++i) {
            char ch = descr.charAt(i);
            if (ch <= '\u001f' || ch >= '\u007f' || ch == '\\' || ch == '\'') {
                char[] hex = LdapUtils.hexEncode(ch);
                for (int j = 0; j < hex.length; j += 2) {
                    sb.append('\\').append(hex[j]).append(hex[j + 1]);
                }
                continue;
            }
            sb.append(ch);
        }
    }

    public static String formatOids(String ... oids) {
        StringBuilder sb = new StringBuilder();
        if (oids.length == 1) {
            sb.append(oids[0]).append(" ");
        } else {
            sb.append("( ");
            for (int i = 0; i < oids.length; ++i) {
                sb.append(oids[i]);
                if (i < oids.length - 1) {
                    sb.append(" $ ");
                    continue;
                }
                sb.append(" ");
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    public static String formatNumbers(int ... numbers) {
        StringBuilder sb = new StringBuilder();
        if (numbers.length == 1) {
            sb.append(numbers[0]).append(" ");
        } else {
            sb.append("( ");
            for (int number : numbers) {
                sb.append(number).append(" ");
            }
            sb.append(") ");
        }
        return sb.toString();
    }

    public static LdapEntry getLdapEntry(ConnectionFactory factory, String dn, String filter, String ... retAttrs) throws LdapException {
        SearchOperation search = new SearchOperation(factory);
        SearchResponse result = search.execute(SearchRequest.objectScopeSearchRequest(dn, retAttrs, filter));
        if (!result.isSuccess()) {
            throw new LdapException("Unsuccessful search for schema: " + String.valueOf(result));
        }
        return result.getEntry();
    }
}

