/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.referral;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.LdapURL;
import org.ldaptive.LdapUtils;
import org.ldaptive.Operation;
import org.ldaptive.Request;
import org.ldaptive.Result;
import org.ldaptive.ResultCode;
import org.ldaptive.referral.ReferralConnectionFactory;
import org.ldaptive.transport.MessageFunctional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFollowReferralHandler<Q extends Request, S extends Result>
extends MessageFunctional.Function<Q, S, S, S> {
    protected static final int DEFAULT_REFERRAL_LIMIT = 10;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final int referralLimit;
    protected final int referralDepth;
    private final ReferralConnectionFactory connectionFactory;
    private final boolean throwOnFailure;

    public AbstractFollowReferralHandler(int limit, int depth, ReferralConnectionFactory factory, boolean tf) {
        this.referralLimit = limit;
        this.referralDepth = depth;
        this.connectionFactory = factory;
        this.throwOnFailure = tf;
    }

    public int getReferralLimit() {
        return this.referralLimit;
    }

    public int getReferralDepth() {
        return this.referralDepth;
    }

    public ReferralConnectionFactory getReferralConnectionFactory() {
        return this.connectionFactory;
    }

    public boolean getThrowOnFailure() {
        return this.throwOnFailure;
    }

    protected abstract Q createReferralRequest(LdapURL var1);

    protected abstract Operation<Q, S> createReferralOperation(ConnectionFactory var1);

    protected Set<ResultCode> getSuccessResultCodes() {
        return Set.of(ResultCode.SUCCESS);
    }

    protected S followReferral(String[] referralUrls) throws LdapException {
        Result referralResult = null;
        List<String> urls = Arrays.asList(referralUrls);
        Collections.shuffle(urls);
        this.logger.debug("Following referral with URLs: {}", urls);
        for (String url : urls) {
            LdapURL ldapUrl = new LdapURL(url);
            if (ldapUrl.getHostname() == null) continue;
            ConnectionFactory cf = this.connectionFactory.getConnectionFactory(ldapUrl.getHostnameWithSchemeAndPort());
            try {
                Q referralRequest = this.createReferralRequest(ldapUrl);
                Operation<Q, S> op = this.createReferralOperation(cf);
                this.logger.debug("Created referral request {} for {}", referralRequest, op);
                referralResult = op.execute(referralRequest);
            }
            catch (LdapException e) {
                if (this.throwOnFailure || e.getResultCode() == ResultCode.REFERRAL_LIMIT_EXCEEDED) {
                    throw e;
                }
                this.logger.warn("Could not follow referral to {}", (Object)url, (Object)e);
            }
            catch (Exception e) {
                if (this.throwOnFailure) {
                    throw e;
                }
                this.logger.warn("Could not follow referral to {}", (Object)url, (Object)e);
            }
            if (referralResult == null || referralResult.getResultCode() != ResultCode.SUCCESS && referralResult.getResultCode() != ResultCode.REFERRAL_LIMIT_EXCEEDED) continue;
            break;
        }
        this.logger.debug("Received referral result {}", referralResult);
        return (S)referralResult;
    }

    @Override
    public S apply(S result) {
        LdapUtils.assertNotNullArg(result, "Response cannot be null");
        if (!ResultCode.REFERRAL.equals((Object)result.getResultCode()) || result.getReferralURLs() == null || result.getReferralURLs().length == 0) {
            return result;
        }
        if (this.referralDepth > this.referralLimit) {
            throw new RuntimeException(new LdapException(ResultCode.REFERRAL_LIMIT_EXCEEDED, "Referral limit of " + this.referralLimit + " exceeded"));
        }
        S referralResult = result;
        try {
            S r = this.followReferral(result.getReferralURLs());
            if (r != null || this.referralDepth > 1) {
                referralResult = r;
            }
        }
        catch (LdapException e) {
            throw new RuntimeException(e);
        }
        if (!(this.referralDepth != 1 || referralResult != null && this.getSuccessResultCodes().contains((Object)referralResult.getResultCode()))) {
            if (this.getThrowOnFailure()) {
                throw new RuntimeException(new LdapException(ResultCode.LOCAL_ERROR, "Could not follow referral " + String.valueOf(referralResult)));
            }
            referralResult = result;
        }
        return referralResult;
    }
}

