/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.ldaptive.AbstractFreezable;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapUtils;
import org.ldaptive.SearchConnectionValidator;
import org.ldaptive.concurrent.CallableWorker;
import org.ldaptive.pool.ActivationException;
import org.ldaptive.pool.ConnectionActivator;
import org.ldaptive.pool.ConnectionPassivator;
import org.ldaptive.pool.ConnectionPool;
import org.ldaptive.pool.IdlePruneStrategy;
import org.ldaptive.pool.PoolException;
import org.ldaptive.pool.PooledConnectionProxy;
import org.ldaptive.pool.PooledConnectionStatistics;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.pool.Queue;
import org.ldaptive.pool.QueueType;
import org.ldaptive.pool.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionPool
extends AbstractFreezable
implements ConnectionPool {
    public static final int DEFAULT_MIN_POOL_SIZE = 3;
    public static final int DEFAULT_MAX_POOL_SIZE = 10;
    private static final int ALLOWED_POOL_SIZE = 65535;
    private static final Duration MAX_WORKER_TIME = Duration.ofMinutes(5L);
    private static final AtomicInteger POOL_ID = new AtomicInteger();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ReentrantLock poolLock = new ReentrantLock();
    protected final Condition poolNotEmpty = this.poolLock.newCondition();
    protected final ReentrantLock checkOutLock = new ReentrantLock();
    protected Queue<PooledConnectionProxy> available;
    protected Queue<PooledConnectionProxy> active;
    private String name = "ldaptive-pool-" + POOL_ID.incrementAndGet();
    private int minPoolSize = 3;
    private int maxPoolSize = 10;
    private boolean validateOnCheckIn;
    private boolean validateOnCheckOut;
    private boolean validatePeriodically;
    private ConnectionActivator activator = new ConnectionActivator(){

        @Override
        public Boolean apply(Connection conn) {
            return true;
        }

        public String toString() {
            return "DEFAULT_ACTIVATOR";
        }
    };
    private ConnectionPassivator passivator = new ConnectionPassivator(){

        @Override
        public Boolean apply(Connection conn) {
            return true;
        }

        public String toString() {
            return "DEFAULT_PASSIVATOR";
        }
    };
    private ConnectionValidator validator = new SearchConnectionValidator();
    private PruneStrategy pruneStrategy = new IdlePruneStrategy();
    private DefaultConnectionFactory connectionFactory;
    private boolean connectOnCreate = true;
    private QueueType queueType = QueueType.LIFO;
    private ScheduledExecutorService poolExecutor;
    private volatile boolean initialized;
    private boolean failFastInitialize = true;

    @Override
    public void freeze() {
        super.freeze();
        AbstractConnectionPool.freeze(this.activator);
        AbstractConnectionPool.freeze(this.passivator);
        AbstractConnectionPool.freeze(this.validator);
        AbstractConnectionPool.freeze(this.pruneStrategy);
        AbstractConnectionPool.freeze(this.connectionFactory);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.assertMutable();
        LdapUtils.assertNotNullArg(s, "Pool name cannot be null");
        this.logger.trace("setting name: {}", (Object)s);
        this.name = s;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int size) {
        this.assertMutable();
        if (size < 0) {
            throw new IllegalArgumentException("Minimum pool size must be greater than or equal to 0 for pool " + this.name);
        }
        if (size > 65535) {
            throw new IllegalArgumentException("Minimum pool size cannot exceed 65535 for pool " + this.name);
        }
        this.logger.trace("setting minPoolSize: {}", (Object)size);
        this.minPoolSize = size;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int size) {
        this.assertMutable();
        if (size < 0) {
            throw new IllegalArgumentException("Maximum pool size must be greater than or equal to 0 for pool " + this.name);
        }
        if (size > 65535) {
            throw new IllegalArgumentException("Maximum pool size cannot exceed 65535 for pool " + this.name);
        }
        this.logger.trace("setting maxPoolSize: {}", (Object)size);
        this.maxPoolSize = size;
    }

    public boolean isValidateOnCheckIn() {
        return this.validateOnCheckIn;
    }

    public void setValidateOnCheckIn(boolean b) {
        this.assertMutable();
        this.logger.trace("setting validateOnCheckIn: {}", (Object)b);
        this.validateOnCheckIn = b;
    }

    public boolean isValidateOnCheckOut() {
        return this.validateOnCheckOut;
    }

    public void setValidateOnCheckOut(boolean b) {
        this.assertMutable();
        this.logger.trace("setting validateOnCheckOut: {}", (Object)b);
        this.validateOnCheckOut = b;
    }

    public boolean isValidatePeriodically() {
        return this.validatePeriodically;
    }

    public void setValidatePeriodically(boolean b) {
        this.assertMutable();
        this.logger.trace("setting validatePeriodically: {}", (Object)b);
        this.validatePeriodically = b;
    }

    public ConnectionActivator getActivator() {
        return this.activator;
    }

    public void setActivator(ConnectionActivator a) {
        this.assertMutable();
        this.logger.trace("setting activator: {}", (Object)a);
        this.activator = a;
    }

    public ConnectionPassivator getPassivator() {
        return this.passivator;
    }

    public void setPassivator(ConnectionPassivator p) {
        this.assertMutable();
        this.logger.trace("setting passivator: {}", (Object)p);
        this.passivator = p;
    }

    public ConnectionValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ConnectionValidator cv) {
        this.assertMutable();
        this.logger.trace("setting validator: {}", (Object)cv);
        this.validator = cv;
    }

    public PruneStrategy getPruneStrategy() {
        return this.pruneStrategy;
    }

    public void setPruneStrategy(PruneStrategy ps) {
        this.assertMutable();
        this.logger.trace("setting pruneStrategy: {}", (Object)ps);
        this.pruneStrategy = ps;
    }

    public DefaultConnectionFactory getDefaultConnectionFactory() {
        return this.connectionFactory;
    }

    public void setDefaultConnectionFactory(DefaultConnectionFactory cf) {
        this.assertMutable();
        this.logger.trace("setting defaultConnectionFactory: {}", (Object)cf);
        this.connectionFactory = LdapUtils.assertNotNullArg(cf, "Connection factory cannot be null");
    }

    public boolean getConnectOnCreate() {
        return this.connectOnCreate;
    }

    public void setConnectOnCreate(boolean b) {
        this.assertMutable();
        this.logger.trace("setting connectOnCreate: {}", (Object)b);
        this.connectOnCreate = b;
    }

    public QueueType getQueueType() {
        return this.queueType;
    }

    public void setQueueType(QueueType type) {
        this.assertMutable();
        this.logger.trace("setting queueType: {}", (Object)type);
        this.queueType = LdapUtils.assertNotNullArg(type, "Queue type cannot be null");
    }

    public boolean getFailFastInitialize() {
        return this.failFastInitialize;
    }

    public void setFailFastInitialize(boolean b) {
        this.assertMutable();
        this.logger.trace("setting failFastInitialize: {}", (Object)b);
        this.failFastInitialize = b;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected void throwIfNotInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Pool " + this.name + " is not initialized");
        }
    }

    @Override
    public synchronized void initialize() {
        if (this.initialized) {
            throw new IllegalStateException("Pool " + this.name + " has already been initialized");
        }
        this.logger.debug("Beginning pool initialization for {}", (Object)this);
        if (this.pruneStrategy == null) {
            throw new IllegalStateException("No prune strategy configured for pool " + this.name);
        }
        if (this.activator == null) {
            throw new IllegalStateException("No activator configured for pool " + this.name);
        }
        if (this.passivator == null) {
            throw new IllegalStateException("No passivator configured for pool " + this.name);
        }
        if (this.maxPoolSize < this.minPoolSize) {
            throw new IllegalStateException("Max pool size " + this.maxPoolSize + " must be greater than or equal to min pool size " + this.minPoolSize);
        }
        this.available = new Queue(this.queueType);
        this.active = new Queue(this.queueType);
        IllegalStateException growException = null;
        try {
            this.createAvailableConnections(this.minPoolSize, true, false);
        }
        catch (IllegalStateException e) {
            growException = e;
        }
        if (this.available.isEmpty() && this.minPoolSize > 0) {
            if (this.failFastInitialize) {
                this.closeAllConnections();
                throw new IllegalStateException("Could not initialize pool size for pool " + this.name, growException != null ? growException.getCause() : null);
            }
            this.logger.info("Could not initialize pool size (pool is empty) for {}", (Object)this);
        }
        this.logger.debug("Initialized available queue {} for {}", this.available, (Object)this);
        this.poolExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, this.name + "@" + this.hashCode());
            t.setDaemon(true);
            return t;
        });
        this.poolExecutor.scheduleAtFixedRate(() -> {
            this.logger.debug("Begin prune task for {}", (Object)this);
            try {
                this.prune();
            }
            catch (Exception e) {
                this.logger.warn("Prune task failed for {}", (Object)this);
            }
            this.logger.debug("End prune task for {}", (Object)this);
        }, this.pruneStrategy.getPrunePeriod().toMillis(), this.pruneStrategy.getPrunePeriod().toMillis(), TimeUnit.MILLISECONDS);
        this.logger.debug("Prune pool task scheduled for {}", (Object)this);
        if (this.validatePeriodically) {
            this.poolExecutor.scheduleAtFixedRate(() -> {
                this.logger.debug("Begin validate task for {}", (Object)this);
                try {
                    this.validate();
                }
                catch (Exception e) {
                    this.logger.warn("Validation task failed for {}", (Object)this);
                }
                this.logger.debug("End validate task for {}", (Object)this);
            }, this.validator.getValidatePeriod().toMillis(), this.validator.getValidatePeriod().toMillis(), TimeUnit.MILLISECONDS);
            this.logger.debug("Validate pool task scheduled for {}", (Object)this);
        }
        this.freeze();
        this.initialized = true;
        this.logger.info("Pool initialized for {}", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void grow(int size) {
        if (this.checkOutLock.tryLock()) {
            try {
                int numConnsToAdd;
                this.logger.trace("waiting for pool lock to initialize pool {}", (Object)this.poolLock.getQueueLength());
                this.poolLock.lock();
                try {
                    if (!this.initialized) {
                        return;
                    }
                    int currentPoolSize = this.active.size() + this.available.size();
                    this.logger.debug("Checking connection pool size >= {} for {}", (Object)size, (Object)this);
                    numConnsToAdd = size - currentPoolSize;
                    if (numConnsToAdd <= 0) {
                        this.logger.debug("Current pool size {} exceeds requested size {}, grow not performed for {}", new Object[]{currentPoolSize, size, this});
                    }
                }
                finally {
                    this.poolLock.unlock();
                }
                if (numConnsToAdd > 0) {
                    this.createAvailableConnections(numConnsToAdd, false, true);
                }
                this.logger.debug("Pool size after grow is {} for {}", (Object)(this.available.size() + this.active.size()), (Object)this);
            }
            finally {
                this.checkOutLock.unlock();
            }
        }
        this.logger.debug("Grow no-op, checkout is creating a connection for {}", (Object)this);
    }

    @Override
    public synchronized void close() {
        this.logger.debug("Closing {} of size {}", (Object)this, (Object)(this.available.size() + this.active.size()));
        this.poolLock.lock();
        try {
            this.closeAllConnections();
            if (this.poolExecutor != null && !this.poolExecutor.isShutdown()) {
                this.poolExecutor.shutdown();
            }
            this.initialized = false;
            this.logger.info("Pool {} closed", (Object)this);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeAllConnections() {
        this.poolLock.lock();
        try {
            if (this.available.isEmpty() && this.active.isEmpty()) {
                return;
            }
            ArrayList<PooledConnectionProxy> removeConns = new ArrayList<PooledConnectionProxy>(this.available.size() + this.active.size());
            while (!this.available.isEmpty()) {
                removeConns.add(this.available.remove());
            }
            while (!this.active.isEmpty()) {
                removeConns.add(this.active.remove());
            }
            CallableWorker<PooledConnectionProxy> callableWorker = new CallableWorker<PooledConnectionProxy>(this.name + "-close", MAX_WORKER_TIME);
            try {
                this.closeConnections(callableWorker, removeConns);
            }
            finally {
                callableWorker.shutdown();
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    private void closeConnections(CallableWorker<PooledConnectionProxy> callableWorker, List<PooledConnectionProxy> connections) {
        if (connections.isEmpty()) {
            return;
        }
        ArrayList removeConns = new ArrayList(connections.size());
        connections.forEach(pc -> removeConns.add(() -> {
            pc.getConnection().close();
            return pc;
        }));
        List<ExecutionException> exceptions = callableWorker.execute(removeConns, pc -> this.logger.trace("removed {} from {}", pc, (Object)this));
        for (ExecutionException e : exceptions) {
            this.logger.debug("Error closing connection for {}", (Object)this, (Object)(e.getCause() != null ? e.getCause() : e));
        }
    }

    @Override
    public abstract Connection getConnection() throws PoolException;

    public abstract void putConnection(Connection var1);

    private PooledConnectionProxy createConnection(boolean throwOnFailure) {
        Connection c;
        block4: {
            c = this.connectionFactory.getConnection();
            if (this.connectOnCreate) {
                try {
                    c.open();
                }
                catch (Exception e) {
                    this.logger.debug("Unable to open connection for {}}", (Object)this, (Object)e);
                    c.close();
                    c = null;
                    if (!throwOnFailure) break block4;
                    throw new IllegalStateException("Unable to open connection for pool " + this.name, e);
                }
            }
        }
        if (c != null) {
            return new DefaultPooledConnectionProxy(c);
        }
        return null;
    }

    private List<PooledConnectionProxy> createConnections(CallableWorker<PooledConnectionProxy> callableWorker, int count, boolean throwOnFailure) {
        if (count <= 0) {
            return Collections.emptyList();
        }
        ArrayList<PooledConnectionProxy> connections = new ArrayList<PooledConnectionProxy>(count);
        List<ExecutionException> exceptions = callableWorker.execute(() -> {
            PooledConnectionProxy pc = null;
            for (int i = 0; pc == null && i < 2; ++i) {
                try {
                    pc = this.createConnection(true);
                    if (pc == null || !this.connectOnCreate || this.passivateAndValidateConnection(pc)) continue;
                    pc.getConnection().close();
                    pc = null;
                    continue;
                }
                catch (IllegalStateException e) {
                    if (i == 1) {
                        throw e;
                    }
                    pc = null;
                }
            }
            return pc;
        }, count, pc -> {
            if (pc != null) {
                connections.add((PooledConnectionProxy)pc);
            }
        });
        if (connections.size() < count && throwOnFailure) {
            try {
                if (!exceptions.isEmpty()) {
                    ExecutionException e = exceptions.get(0);
                    if (e.getCause() instanceof IllegalStateException) {
                        throw (IllegalStateException)e.getCause();
                    }
                    throw new IllegalStateException(e.getCause() == null ? e : e.getCause());
                }
                throw new IllegalStateException("Could not create the requested number of connections");
            }
            catch (Throwable throwable) {
                this.closeConnections(callableWorker, connections);
                throw throwable;
            }
        }
        return connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAvailableConnections(int count, boolean throwOnFailure, boolean throwIfNotInitialized) {
        if (count <= 0) {
            return;
        }
        CallableWorker<PooledConnectionProxy> callableWorker = new CallableWorker<PooledConnectionProxy>(this.name + "-create", MAX_WORKER_TIME);
        List<PooledConnectionProxy> connections = null;
        try {
            connections = this.createConnections(callableWorker, count, throwOnFailure);
            ArrayList<PooledConnectionProxy> closeConnections = new ArrayList<PooledConnectionProxy>();
            this.poolLock.lock();
            try {
                if (throwIfNotInitialized) {
                    this.throwIfNotInitialized();
                }
                for (PooledConnectionProxy pc : connections) {
                    if (this.available.size() + this.active.size() < this.maxPoolSize) {
                        this.available.add(pc);
                        this.poolNotEmpty.signal();
                        pc.getPooledConnectionStatistics().addAvailableStat();
                        this.logger.debug("Added available connection {} for {}", (Object)pc.getConnection(), (Object)this);
                        continue;
                    }
                    closeConnections.add(pc);
                }
            }
            finally {
                this.poolLock.unlock();
            }
            if (!closeConnections.isEmpty()) {
                this.closeConnections(callableWorker, closeConnections);
            }
        }
        catch (Exception e) {
            if (connections != null) {
                this.closeConnections(callableWorker, connections);
            }
            throw e;
        }
        finally {
            callableWorker.shutdown();
        }
    }

    protected PooledConnectionProxy createAvailableConnection(boolean throwOnFailure) {
        PooledConnectionProxy pc = this.createConnection(throwOnFailure);
        if (pc != null) {
            this.poolLock.lock();
            try {
                if (this.initialized && this.available.size() + this.active.size() < this.maxPoolSize) {
                    this.available.add(pc);
                    this.poolNotEmpty.signal();
                    pc.getPooledConnectionStatistics().addAvailableStat();
                    this.logger.debug("Added available connection {} for {}", (Object)pc.getConnection(), (Object)this);
                }
                pc.getConnection().close();
                pc = null;
            }
            finally {
                this.poolLock.unlock();
            }
        } else {
            this.logger.debug("Unable to create available connection for {}", (Object)this);
        }
        return pc;
    }

    protected PooledConnectionProxy createActiveConnection(boolean throwOnFailure) {
        PooledConnectionProxy pc = this.createConnection(throwOnFailure);
        if (pc != null) {
            this.poolLock.lock();
            try {
                if (this.initialized && this.available.size() + this.active.size() < this.maxPoolSize) {
                    this.active.add(pc);
                    pc.getPooledConnectionStatistics().addActiveStat();
                    this.logger.debug("Added active connection {} for {}", (Object)pc.getConnection(), (Object)this);
                }
                pc.getConnection().close();
                pc = null;
            }
            finally {
                this.poolLock.unlock();
            }
        } else {
            this.logger.debug("Unable to create active connection for {}", (Object)this);
        }
        return pc;
    }

    protected void removeAvailableConnection(PooledConnectionProxy pc) {
        boolean destroy = false;
        this.poolLock.lock();
        try {
            if (this.available.remove(pc)) {
                destroy = true;
            } else {
                this.logger.warn("Attempt to remove unknown available connection {} from {}", (Object)pc.getConnection(), (Object)this);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            pc.getConnection().close();
            this.logger.debug("Removed {} from {}", (Object)pc.getConnection(), (Object)this);
        }
    }

    protected void removeActiveConnection(PooledConnectionProxy pc) {
        boolean destroy = false;
        this.poolLock.lock();
        try {
            if (this.active.remove(pc)) {
                destroy = true;
            } else {
                this.logger.warn("Attempt to remove unknown active connection {} from {}", (Object)pc.getConnection(), (Object)this);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            pc.getConnection().close();
            this.logger.debug("Removed {} from {}", (Object)pc.getConnection(), (Object)this);
        }
    }

    protected void removeAvailableAndActiveConnection(PooledConnectionProxy pc) {
        boolean destroy = false;
        this.poolLock.lock();
        try {
            if (this.available.remove(pc)) {
                destroy = true;
            }
            if (this.active.remove(pc)) {
                destroy = true;
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (destroy) {
            pc.getConnection().close();
            this.logger.debug("Removed {} from {}", (Object)pc.getConnection(), (Object)this);
        }
    }

    protected void activateAndValidateConnection(PooledConnectionProxy pc) throws PoolException {
        if (!((Boolean)this.activator.apply(pc.getConnection())).booleanValue()) {
            this.logger.debug("Failed activation on {} with {} for {}", new Object[]{pc.getConnection(), this.activator, this});
            this.removeAvailableAndActiveConnection(pc);
            throw new ActivationException("Activation of connection failed for pool " + this.name);
        }
        if (this.validateOnCheckOut && !((Boolean)this.validator.apply(pc.getConnection())).booleanValue()) {
            this.logger.debug("Failed check out validation on {} with {} for {}", new Object[]{pc.getConnection(), this.validator, this});
            this.removeAvailableAndActiveConnection(pc);
            throw new ValidationException("Validation of connection failed for pool " + this.name);
        }
    }

    protected boolean passivateAndValidateConnection(PooledConnectionProxy pc) {
        if (!pc.getConnection().isOpen()) {
            this.logger.debug("Failed validation on {} for {}, not open", (Object)pc.getConnection(), (Object)this);
            return false;
        }
        boolean valid = false;
        if (((Boolean)this.passivator.apply(pc.getConnection())).booleanValue()) {
            if (this.validateOnCheckIn) {
                if (((Boolean)this.validator.apply(pc.getConnection())).booleanValue()) {
                    this.logger.trace("connection {} passed initialize validation", (Object)pc);
                    valid = true;
                } else {
                    this.logger.debug("Failed check in validation on {} with {} for {}", new Object[]{pc.getConnection(), this.validator, this});
                }
            } else {
                valid = true;
            }
        } else {
            this.logger.debug("Failed passivation on {} with {} for {}", new Object[]{pc.getConnection(), this.passivator, this});
        }
        return valid;
    }

    public void prune() {
        this.logger.trace("waiting for pool lock to prune {} for {}", (Object)this.poolLock.getQueueLength(), (Object)this);
        int numConnPruned = 0;
        this.poolLock.lock();
        try {
            if (!this.initialized) {
                return;
            }
            if (!this.available.isEmpty()) {
                int numAvailable = this.available.size();
                this.pruneStrategy.accept(this.available::iterator);
                numConnPruned = numAvailable - this.available.size();
            } else {
                this.logger.debug("No available connections, no connections pruned for {}", (Object)this);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        if (numConnPruned == 0) {
            this.logger.debug("Prune strategy {} did not remove any connections for {}", (Object)this.pruneStrategy, (Object)this);
        } else {
            this.grow(this.minPoolSize);
            this.logger.info("Available pool size pruned to {} for {}", (Object)this.available.size(), (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        ArrayList<PooledConnectionProxy> remove = new ArrayList<PooledConnectionProxy>();
        this.poolLock.lock();
        try {
            if (!this.initialized) {
                return;
            }
            int initialPoolSize = this.available.size() + this.active.size();
            if (!this.available.isEmpty()) {
                this.logger.debug("Validate available pool of size {} for {}", (Object)this.available.size(), (Object)this);
                HashMap<PooledConnectionProxy, Supplier<Boolean>> results = new HashMap<PooledConnectionProxy, Supplier<Boolean>>(this.available.size());
                for (PooledConnectionProxy pooledConnectionProxy : this.available) {
                    this.logger.trace("validating {} for {}", (Object)pooledConnectionProxy, (Object)this);
                    results.put(pooledConnectionProxy, this.validator.applyAsync(pooledConnectionProxy.getConnection()));
                }
                for (Map.Entry entry : results.entrySet()) {
                    Boolean validateResult = (Boolean)((Supplier)entry.getValue()).get();
                    if (validateResult != null && validateResult.booleanValue()) {
                        this.logger.trace("passed validation on {} with {} for {}", new Object[]{entry.getKey(), this.validator, this});
                        continue;
                    }
                    this.logger.debug("Failed validation on {} with {} for {}, {}", new Object[]{((PooledConnectionProxy)entry.getKey()).getConnection(), this.validator, this, validateResult == null ? "validator timeout exceeded" : "validator returned false"});
                    remove.add((PooledConnectionProxy)entry.getKey());
                }
                for (PooledConnectionProxy pooledConnectionProxy : remove) {
                    this.logger.trace("validate removing {} from {}", (Object)pooledConnectionProxy, (Object)this);
                    this.available.remove(pooledConnectionProxy);
                    this.logger.trace("validate removed {} from {}", (Object)pooledConnectionProxy, (Object)this);
                }
            } else {
                this.logger.debug("No available connections, no validation performed for {}", (Object)this);
            }
            if (initialPoolSize == this.available.size() + this.active.size()) {
                this.logger.debug("Pool size of {} unchanged after validation for {}", (Object)(this.available.size() + this.active.size()), (Object)this);
            } else {
                this.logger.info("Pool size after validation is {} for {}", (Object)(this.available.size() + this.active.size()), (Object)this);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        remove.forEach(pc -> pc.getConnection().close());
        this.grow(this.minPoolSize);
    }

    @Override
    public int availableCount() {
        if (this.available == null) {
            return 0;
        }
        return this.available.size();
    }

    @Override
    public int activeCount() {
        if (this.active == null) {
            return 0;
        }
        return this.active.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PooledConnectionStatistics> getPooledConnectionStatistics() {
        this.poolLock.lock();
        try {
            HashSet<PooledConnectionStatistics> stats = new HashSet<PooledConnectionStatistics>();
            for (PooledConnectionProxy cp : this.available) {
                stats.add(cp.getPooledConnectionStatistics());
            }
            for (PooledConnectionProxy cp : this.active) {
                stats.add(cp.getPooledConnectionStatistics());
            }
            Set set = Collections.unmodifiableSet(stats);
            return set;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    protected Connection createConnectionProxy(PooledConnectionProxy pc) {
        return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)pc);
    }

    protected PooledConnectionProxy retrieveConnectionProxy(Connection proxy) {
        return (PooledConnectionProxy)Proxy.getInvocationHandler(proxy);
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.hashCode() + "::name=" + this.name + ", minPoolSize=" + this.minPoolSize + ", maxPoolSize=" + this.maxPoolSize + ", validateOnCheckIn=" + this.validateOnCheckIn + ", validateOnCheckOut=" + this.validateOnCheckOut + ", validatePeriodically=" + this.validatePeriodically + ", activator=" + String.valueOf(this.activator) + ", passivator=" + String.valueOf(this.passivator) + ", validator=" + String.valueOf(this.validator) + ", pruneStrategy=" + String.valueOf(this.pruneStrategy) + ", connectOnCreate=" + this.connectOnCreate + ", connectionFactory=" + String.valueOf(this.connectionFactory) + ", failFastInitialize=" + this.failFastInitialize + ", initialized=" + this.initialized + ", availableCount=" + this.availableCount() + ", activeCount=" + this.activeCount();
    }

    protected class DefaultPooledConnectionProxy
    implements PooledConnectionProxy {
        private static final int HASH_CODE_SEED = 503;
        private final Connection conn;
        private final Instant createdTime = Instant.now();
        private final PooledConnectionStatistics statistics;

        public DefaultPooledConnectionProxy(Connection c) {
            this.statistics = new PooledConnectionStatistics(AbstractConnectionPool.this.pruneStrategy.getStatisticsSize());
            this.conn = c;
        }

        @Override
        public ConnectionPool getConnectionPool() {
            return AbstractConnectionPool.this;
        }

        @Override
        public Connection getConnection() {
            return this.conn;
        }

        @Override
        public Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public PooledConnectionStatistics getPooledConnectionStatistics() {
            return this.statistics;
        }

        @Override
        public int getMinPoolSize() {
            return AbstractConnectionPool.this.minPoolSize;
        }

        @Override
        public int getMaxPoolSize() {
            return AbstractConnectionPool.this.maxPoolSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DefaultPooledConnectionProxy) {
                DefaultPooledConnectionProxy v = (DefaultPooledConnectionProxy)o;
                return LdapUtils.areEqual(this.conn, v.conn);
            }
            return false;
        }

        public int hashCode() {
            return LdapUtils.computeHashCode(503, this.conn);
        }

        public String toString() {
            return this.getClass().getName() + "@" + this.hashCode() + "::conn=" + String.valueOf(this.conn) + ", createdTime=" + String.valueOf(this.createdTime) + ", statistics=" + String.valueOf(this.statistics);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object retValue = null;
            if ("open".equals(method.getName())) {
                if (!this.conn.isOpen()) {
                    try {
                        retValue = method.invoke((Object)this.conn, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
            } else if ("close".equals(method.getName())) {
                AbstractConnectionPool.this.putConnection((Connection)proxy);
            } else {
                try {
                    retValue = method.invoke((Object)this.conn, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return retValue;
        }
    }
}

