/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.control;

import org.ldaptive.LdapUtils;
import org.ldaptive.asn1.DERBuffer;
import org.ldaptive.asn1.OctetStringType;
import org.ldaptive.control.AbstractResponseControl;

public class PasswordExpiringControl
extends AbstractResponseControl {
    public static final String OID = "2.16.840.1.113730.3.4.5";
    private static final int HASH_CODE_SEED = 797;
    private int timeBeforeExpiration;

    public PasswordExpiringControl() {
        super(OID);
    }

    public PasswordExpiringControl(boolean critical) {
        super(OID, critical);
    }

    public PasswordExpiringControl(int time) {
        super(OID);
        this.timeBeforeExpiration = time;
        this.freeze();
    }

    public PasswordExpiringControl(int time, boolean critical) {
        super(OID, critical);
        this.timeBeforeExpiration = time;
        this.freeze();
    }

    public int getTimeBeforeExpiration() {
        return this.timeBeforeExpiration;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PasswordExpiringControl && super.equals(o)) {
            PasswordExpiringControl v = (PasswordExpiringControl)o;
            return LdapUtils.areEqual(this.timeBeforeExpiration, v.timeBeforeExpiration);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(797, this.getOID(), this.getCriticality(), this.timeBeforeExpiration);
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::criticality=" + this.getCriticality() + ", timeBeforeExpiration=" + this.timeBeforeExpiration + "]";
    }

    @Override
    public void decode(DERBuffer encoded) {
        this.freezeAndAssertMutable();
        try {
            String time = OctetStringType.decode(encoded);
            this.timeBeforeExpiration = Integer.parseInt(time);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing response", e);
        }
    }
}

