/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import org.ldaptive.LdapUtils;

public final class Credential {
    private final byte[] bytes;

    public Credential(String password) {
        LdapUtils.assertNotNullArg(password, "Password cannot be null");
        this.bytes = LdapUtils.utf8Encode(password, false);
    }

    public Credential(char[] password) {
        LdapUtils.assertNotNullArg(password, "Password cannot be null");
        this.bytes = LdapUtils.utf8Encode(password, false);
    }

    public Credential(byte[] password) {
        LdapUtils.assertNotNullArg(password, "Password cannot be null");
        this.bytes = password;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getString() {
        return LdapUtils.utf8Encode(this.bytes, false);
    }

    public boolean isNull() {
        return this.bytes == null;
    }

    public boolean isEmpty() {
        return this.bytes.length == 0;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::bytes=" + LdapUtils.utf8Encode(this.bytes) + "]";
    }

    public static Credential copy(Credential credential) {
        return new Credential(LdapUtils.copyArray(credential.bytes));
    }
}

