/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.ldaptive.AbstractConfig;
import org.ldaptive.ActivePassiveConnectionStrategy;
import org.ldaptive.ClosedRetryMetadata;
import org.ldaptive.ConnectionInitializer;
import org.ldaptive.ConnectionStrategy;
import org.ldaptive.ConnectionValidator;
import org.ldaptive.LdapUtils;
import org.ldaptive.RetryMetadata;
import org.ldaptive.ssl.SslConfig;

public final class ConnectionConfig
extends AbstractConfig {
    public static final Predicate<RetryMetadata> ONE_RECONNECT_ATTEMPT = new Predicate<RetryMetadata>(){

        @Override
        public boolean test(RetryMetadata metadata) {
            return metadata instanceof ClosedRetryMetadata && metadata.getAttempts() == 0;
        }

        public String toString() {
            return "ONE_RECONNECT_ATTEMPT";
        }
    };
    public static final Predicate<RetryMetadata> INFINITE_RECONNECT_ATTEMPTS = new Predicate<RetryMetadata>(){

        @Override
        public boolean test(RetryMetadata metadata) {
            if (metadata instanceof ClosedRetryMetadata) {
                if (metadata.getAttempts() > 0) {
                    try {
                        Thread.sleep(Duration.ofSeconds(5L).toMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "INFINITE_RECONNECT_ATTEMPTS";
        }
    };
    public static final Predicate<RetryMetadata> INFINITE_RECONNECT_ATTEMPTS_WITH_BACKOFF = new Predicate<RetryMetadata>(){

        @Override
        public boolean test(RetryMetadata metadata) {
            if (metadata instanceof ClosedRetryMetadata) {
                if (metadata.getAttempts() > 0) {
                    try {
                        Thread.sleep(Duration.ofSeconds(5L).multipliedBy(metadata.getAttempts()).toMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "INFINITE_RECONNECT_ATTEMPTS_WITH_BACKOFF";
        }
    };
    private String ldapUrl;
    private Duration connectTimeout = Duration.ofMinutes(1L);
    private Duration startTLSTimeout = Duration.ofMinutes(1L);
    private Duration responseTimeout = Duration.ofMinutes(1L);
    private Duration reconnectTimeout = Duration.ofMinutes(2L);
    private boolean autoReconnect = true;
    private Predicate<RetryMetadata> autoReconnectCondition = ONE_RECONNECT_ATTEMPT;
    private boolean autoReplay;
    private boolean autoRead = true;
    private SslConfig sslConfig;
    private boolean useStartTLS;
    private ConnectionInitializer[] connectionInitializers;
    private ConnectionStrategy connectionStrategy = new ActivePassiveConnectionStrategy();
    private ConnectionValidator connectionValidator;
    private final Map<String, Object> transportOptions = new HashMap<String, Object>();

    public ConnectionConfig() {
    }

    public ConnectionConfig(String url) {
        this.setLdapUrl(url);
    }

    @Override
    public void freeze() {
        super.freeze();
        ConnectionConfig.freeze(this.sslConfig);
        ConnectionConfig.freeze(this.connectionInitializers);
        ConnectionConfig.freeze(this.connectionStrategy);
        ConnectionConfig.freeze(this.connectionValidator);
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String url) {
        this.assertMutable();
        this.checkStringInput(url, true);
        this.logger.trace("setting ldapUrl: {}", (Object)url);
        this.ldapUrl = url;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration time) {
        this.assertMutable();
        LdapUtils.assertNotNullArgOr(time, Duration::isNegative, "Connect timeout cannot be null or negative");
        this.logger.trace("setting connectTimeout: {}", (Object)time);
        this.connectTimeout = time;
    }

    public Duration getStartTLSTimeout() {
        return this.startTLSTimeout;
    }

    public void setStartTLSTimeout(Duration time) {
        this.assertMutable();
        LdapUtils.assertNotNullArgOr(time, Duration::isNegative, "StartTLS timeout cannot be null or negative");
        this.logger.trace("setting startTLSTimeout: {}", (Object)time);
        this.startTLSTimeout = time;
    }

    public Duration getResponseTimeout() {
        return this.responseTimeout;
    }

    public void setResponseTimeout(Duration time) {
        this.assertMutable();
        LdapUtils.assertNotNullArgOr(time, Duration::isNegative, "Response timeout cannot be null or negative");
        this.logger.trace("setting responseTimeout: {}", (Object)time);
        this.responseTimeout = time;
    }

    public Duration getReconnectTimeout() {
        return this.reconnectTimeout;
    }

    public void setReconnectTimeout(Duration time) {
        this.assertMutable();
        LdapUtils.assertNotNullArgOr(time, Duration::isNegative, "Reconnect timeout cannot be null or negative");
        this.logger.trace("setting reconnectTimeout: {}", (Object)time);
        this.reconnectTimeout = time;
    }

    public boolean getAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean b) {
        this.assertMutable();
        this.logger.trace("setting autoReconnect: {}", (Object)b);
        this.autoReconnect = b;
    }

    public Predicate<RetryMetadata> getAutoReconnectCondition() {
        return this.autoReconnectCondition;
    }

    public void setAutoReconnectCondition(Predicate<RetryMetadata> predicate) {
        this.assertMutable();
        this.logger.trace("setting autoReconnectCondition: {}", predicate);
        this.autoReconnectCondition = predicate;
    }

    public boolean getAutoReplay() {
        return this.autoReplay;
    }

    public void setAutoReplay(boolean b) {
        this.assertMutable();
        this.logger.trace("setting autoReplay: {}", (Object)b);
        this.autoReplay = b;
    }

    public boolean getAutoRead() {
        return this.autoRead;
    }

    public void setAutoRead(boolean b) {
        this.assertMutable();
        this.logger.trace("setting autoRead: {}", (Object)b);
        this.autoRead = b;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public void setSslConfig(SslConfig config) {
        this.assertMutable();
        this.logger.trace("setting sslConfig: {}", (Object)config);
        this.sslConfig = config;
    }

    public boolean getUseStartTLS() {
        return this.useStartTLS;
    }

    public void setUseStartTLS(boolean b) {
        this.assertMutable();
        this.logger.trace("setting useStartTLS: {}", (Object)b);
        this.useStartTLS = b;
    }

    public ConnectionInitializer[] getConnectionInitializers() {
        return LdapUtils.copyArray(this.connectionInitializers);
    }

    public void setConnectionInitializers(ConnectionInitializer ... initializers) {
        this.assertMutable();
        this.checkArrayContainsNull(initializers);
        this.logger.trace("setting connectionInitializers: {}", (Object)Arrays.toString(initializers));
        this.connectionInitializers = LdapUtils.copyArray(initializers);
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(ConnectionStrategy strategy) {
        this.assertMutable();
        this.logger.trace("setting connectionStrategy: {}", (Object)strategy);
        this.connectionStrategy = strategy;
    }

    public ConnectionValidator getConnectionValidator() {
        return this.connectionValidator;
    }

    public void setConnectionValidator(ConnectionValidator validator) {
        this.assertMutable();
        this.logger.trace("setting connectionValidator: {}", (Object)validator);
        this.connectionValidator = validator;
    }

    public Map<String, ?> getTransportOptions() {
        return Collections.unmodifiableMap(this.transportOptions);
    }

    public void setTransportOptions(Map<String, ?> options) {
        this.assertMutable();
        this.logger.trace("setting transport options: {}", options);
        this.transportOptions.putAll(options);
    }

    public Object getTransportOption(String id) {
        return this.transportOptions.get(id);
    }

    public void setTransportOption(String id, Object value) {
        this.assertMutable();
        this.logger.trace("setting transport options: {}={}", (Object)id, value);
        this.transportOptions.put(id, value);
    }

    public static ConnectionConfig copy(ConnectionConfig config) {
        ConnectionConfig copy = new ConnectionConfig();
        copy.setLdapUrl(config.ldapUrl);
        copy.setConnectTimeout(config.connectTimeout);
        copy.setStartTLSTimeout(config.startTLSTimeout);
        copy.setResponseTimeout(config.responseTimeout);
        copy.setReconnectTimeout(config.reconnectTimeout);
        copy.setAutoReconnect(config.autoReconnect);
        copy.setAutoReconnectCondition(config.autoReconnectCondition);
        copy.setAutoReplay(config.autoReplay);
        copy.setAutoRead(config.autoRead);
        copy.setSslConfig(config.sslConfig != null ? SslConfig.copy(config.sslConfig) : null);
        copy.setUseStartTLS(config.useStartTLS);
        copy.setConnectionInitializers(config.connectionInitializers != null ? config.connectionInitializers : null);
        copy.setConnectionStrategy(config.connectionStrategy != null ? config.connectionStrategy.newInstance() : null);
        copy.setConnectionValidator(config.connectionValidator);
        copy.setTransportOptions(config.transportOptions);
        return copy;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::ldapUrl=" + this.ldapUrl + ", connectTimeout=" + String.valueOf(this.connectTimeout) + ", startTLSTimeout=" + String.valueOf(this.startTLSTimeout) + ", responseTimeout=" + String.valueOf(this.responseTimeout) + ", reconnectTimeout=" + String.valueOf(this.reconnectTimeout) + ", autoReconnect=" + this.autoReconnect + ", autoReconnectCondition=" + String.valueOf(this.autoReconnectCondition) + ", autoReplay=" + this.autoReplay + ", autoRead=" + this.autoRead + ", sslConfig=" + String.valueOf(this.sslConfig) + ", useStartTLS=" + this.useStartTLS + ", connectionInitializers=" + Arrays.toString(this.connectionInitializers) + ", connectionStrategy=" + String.valueOf(this.connectionStrategy) + ", connectionValidator=" + String.valueOf(this.connectionValidator) + ", transportOptions=" + String.valueOf(this.transportOptions) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ConnectionConfig object = new ConnectionConfig();

        protected Builder() {
        }

        public Builder url(String url) {
            this.object.setLdapUrl(url);
            return this;
        }

        public Builder connectTimeout(Duration timeout) {
            this.object.setConnectTimeout(timeout);
            return this;
        }

        public Builder responseTimeout(Duration timeout) {
            this.object.setResponseTimeout(timeout);
            return this;
        }

        public Builder startTLSTimeout(Duration timeout) {
            this.object.setStartTLSTimeout(timeout);
            return this;
        }

        public Builder reconnectTimeout(Duration timeout) {
            this.object.setReconnectTimeout(timeout);
            return this;
        }

        public Builder autoReconnect(boolean b) {
            this.object.setAutoReconnect(b);
            return this;
        }

        public Builder autoReconnectCondition(Predicate<RetryMetadata> predicate) {
            this.object.setAutoReconnectCondition(predicate);
            return this;
        }

        public Builder autoReplay(boolean b) {
            this.object.setAutoReplay(b);
            return this;
        }

        public Builder autoRead(boolean b) {
            this.object.setAutoRead(b);
            return this;
        }

        public Builder sslConfig(SslConfig config) {
            this.object.setSslConfig(config);
            return this;
        }

        public Builder useStartTLS(boolean b) {
            this.object.setUseStartTLS(b);
            return this;
        }

        public Builder connectionInitializers(ConnectionInitializer ... initializers) {
            this.object.setConnectionInitializers(initializers);
            return this;
        }

        public Builder connectionStrategy(ConnectionStrategy strategy) {
            this.object.setConnectionStrategy(strategy);
            return this;
        }

        public Builder connectionValidator(ConnectionValidator validator) {
            this.object.setConnectionValidator(validator);
            return this;
        }

        public Builder transportOption(String id, Object value) {
            this.object.setTransportOption(id, value);
            return this;
        }

        public ConnectionConfig build() {
            return this.object;
        }
    }
}

