/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.profile.module;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.module.AbstractModule;
import net.shibboleth.profile.module.Module;
import net.shibboleth.profile.module.ModuleContext;
import net.shibboleth.profile.module.ModuleException;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public abstract class PropertyDrivenModule
extends AbstractModule
implements Module {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_RESOURCE = "module.properties";
    @Nonnull
    @NotEmpty
    public static final String MODULE_NAME_PROPERTY = ".name";
    @Nonnull
    @NotEmpty
    public static final String MODULE_DESC_PROPERTY = ".desc";
    @Nonnull
    @NotEmpty
    public static final String MODULE_URL_PROPERTY = ".url";
    @Nonnull
    @NotEmpty
    public static final String MODULE_PLUGIN_PROPERTY = ".plugin";
    @Nonnull
    @NotEmpty
    public static final String MODULE_SRC_PROPERTY = ".src";
    @Nonnull
    @NotEmpty
    public static final String MODULE_DEST_PROPERTY = ".dest";
    @Nonnull
    @NotEmpty
    public static final String MODULE_REPLACE_PROPERTY = ".replace";
    @Nonnull
    @NotEmpty
    public static final String MODULE_OPTIONAL_PROPERTY = ".optional";
    @Nonnull
    @NotEmpty
    public static final String MODULE_EXEC_PROPERTY = ".exec";
    @Nonnull
    @NotEmpty
    public static final String MODULE_WINDOWS_PROPERTY = ".windows";
    @Nonnull
    @NotEmpty
    public static final String MODULE_NONWINDOWS_PROPERTY = ".nonwindows";
    @Nonnull
    @NotEmpty
    public static final String MODULE_POSTENABLE_PROPERTY = ".postenable";
    @Nonnull
    @NotEmpty
    public static final String MODULE_POSTDISABLE_PROPERTY = ".postdisable";
    @Nonnull
    @NotEmpty
    public static final String MODULE_LANGS_PROPERTY = ".langs";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(PropertyDrivenModule.class);
    @Nonnull
    private final Properties moduleProperties;
    @Nonnull
    @NotEmpty
    private String moduleId;
    @Nonnull
    @NotEmpty
    private String moduleName;
    @Nullable
    @NotEmpty
    private String moduleURL;
    @Nullable
    @NotEmpty
    private String pluginId;
    @Nonnull
    private List<String> locales = CollectionSupport.emptyList();
    private boolean requireHttpClient;

    public PropertyDrivenModule(@Nullable String version, @Nonnull Class<? extends Module> claz) throws IOException, ModuleException {
        this(version, (InputStream)Constraint.isNotNull((Object)claz.getResourceAsStream(DEFAULT_RESOURCE), (String)"null resource stream"));
    }

    public PropertyDrivenModule(@Nullable String version, @Nonnull InputStream inputStream) throws IOException, ModuleException {
        super(version);
        this.moduleProperties = new Properties();
        this.moduleProperties.load(inputStream);
        this.moduleId = "";
        this.moduleName = "";
        this.load();
    }

    public PropertyDrivenModule(@Nullable String version, @Nonnull Properties properties) throws ModuleException {
        super(version);
        this.moduleProperties = (Properties)Constraint.isNotNull((Object)properties, (String)"Properties cannot be null");
        this.moduleId = "";
        this.moduleName = "";
        this.load();
    }

    protected void load() throws ModuleException {
        try {
            this.moduleId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)this.moduleProperties.getProperty(this.getClass().getName())), (String)"Module ID missing from properties");
            this.moduleName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)this.moduleProperties.getProperty(this.getId() + MODULE_NAME_PROPERTY)), (String)"Module name missing from properties");
            this.moduleURL = StringSupport.trimOrNull((String)this.moduleProperties.getProperty(this.getId() + MODULE_URL_PROPERTY));
            this.pluginId = StringSupport.trimOrNull((String)this.moduleProperties.getProperty(this.getId() + MODULE_PLUGIN_PROPERTY));
            String langs = this.moduleProperties.getProperty(this.getId() + MODULE_LANGS_PROPERTY, "");
            assert (langs != null);
            this.locales = StringSupport.stringToList((String)langs, (String)", ");
            ArrayList<AbstractModule.BasicModuleResource> resources = new ArrayList<AbstractModule.BasicModuleResource>();
            Integer rnum = 1;
            while (true) {
                String renumstr = "." + rnum.toString();
                String src = this.moduleProperties.getProperty(this.getId() + renumstr + MODULE_SRC_PROPERTY);
                String dest = this.moduleProperties.getProperty(this.getId() + renumstr + MODULE_DEST_PROPERTY);
                if (src == null || dest == null) break;
                Boolean replace = Boolean.valueOf(this.moduleProperties.getProperty(this.getId() + renumstr + MODULE_REPLACE_PROPERTY, "false"));
                Boolean optional = Boolean.valueOf(this.moduleProperties.getProperty(this.getId() + renumstr + MODULE_OPTIONAL_PROPERTY, "false"));
                Boolean exec = Boolean.valueOf(this.moduleProperties.getProperty(this.getId() + renumstr + MODULE_EXEC_PROPERTY, "false"));
                Boolean windows = Boolean.valueOf(this.moduleProperties.getProperty(this.getId() + renumstr + MODULE_WINDOWS_PROPERTY, "true"));
                Boolean nonwindows = Boolean.valueOf(this.moduleProperties.getProperty(this.getId() + renumstr + MODULE_NONWINDOWS_PROPERTY, "true"));
                Path destPath = Path.of(dest, new String[0]);
                if (dest.contains("..") || destPath.isAbsolute() || destPath.startsWith("/")) {
                    throw new ModuleException("Module contained a suspect resource destination");
                }
                if (!this.requireHttpClient) {
                    this.requireHttpClient = src.startsWith("https://") || src.startsWith("http://");
                }
                resources.add(new AbstractModule.BasicModuleResource(src, destPath, replace, optional, exec, windows, nonwindows));
                rnum = rnum + 1;
            }
            this.setResources(resources);
            this.log.debug("Module {} loaded", (Object)this.getId());
            resources.forEach(r -> this.log.debug("Module {}: Resource {} -> {} ({})", new Object[]{this.getId(), r.getSource(), r.getDestination(), r.isReplace() ? "replace" : "noreplace"}));
        }
        catch (ConstraintViolationException e) {
            throw new ModuleException((Exception)((Object)e));
        }
    }

    @Nonnull
    @NotEmpty
    public String getId() {
        return this.moduleId;
    }

    @Override
    @Nonnull
    @NotEmpty
    public String getName(@Nullable ModuleContext moduleContext) {
        String best;
        if (moduleContext != null && (best = Locale.lookupTag(moduleContext.getLanguageRanges(), this.locales)) != null && !best.equals(this.locales.get(0))) {
            String result = this.moduleProperties.getProperty(this.getId() + ".name." + best, this.moduleName);
            assert (result != null);
            return result;
        }
        return this.moduleName;
    }

    @Override
    @Nullable
    @NotEmpty
    public String getDescription(@Nullable ModuleContext moduleContext) {
        String desc;
        String best;
        if (moduleContext != null && (best = Locale.lookupTag(moduleContext.getLanguageRanges(), this.locales)) != null && !best.equals(this.locales.get(0)) && !Strings.isNullOrEmpty((String)(desc = this.moduleProperties.getProperty(this.getId() + ".desc." + best)))) {
            return desc;
        }
        return StringSupport.trimOrNull((String)this.moduleProperties.getProperty(this.getId() + MODULE_DESC_PROPERTY));
    }

    @Override
    @Nullable
    @NotEmpty
    public String getURL() {
        return this.moduleURL;
    }

    public void setURL(@Nullable @NotEmpty String url) {
        this.moduleURL = StringSupport.trimOrNull((String)url);
    }

    @Override
    @Nullable
    @NotEmpty
    public String getOwnerId() {
        return this.pluginId;
    }

    @Override
    public boolean isHttpClientRequired() {
        return this.requireHttpClient;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Module.ModuleResource, Module.ResourceResult> enable(@Nonnull ModuleContext moduleContext) throws ModuleException {
        Map<Module.ModuleResource, Module.ResourceResult> results = super.enable(moduleContext);
        PrintStream msgStream = moduleContext.getMessageStream();
        if (msgStream != null) {
            String msg = null;
            String best = Locale.lookupTag(moduleContext.getLanguageRanges(), this.locales);
            if (best != null && !best.equals(this.locales.get(0))) {
                msg = this.moduleProperties.getProperty(this.getId() + ".postenable." + best);
            }
            if (msg == null) {
                msg = this.moduleProperties.getProperty(this.getId() + MODULE_POSTENABLE_PROPERTY);
            }
            if (msg != null) {
                msgStream.println(msg);
            }
        }
        return results;
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<Module.ModuleResource, Module.ResourceResult> disable(@Nonnull ModuleContext moduleContext, boolean clean) throws ModuleException {
        Map<Module.ModuleResource, Module.ResourceResult> results = super.disable(moduleContext, clean);
        PrintStream msgStream = moduleContext.getMessageStream();
        if (msgStream != null) {
            String msg = null;
            String best = Locale.lookupTag(moduleContext.getLanguageRanges(), this.locales);
            if (best != null && !best.equals(this.locales.get(0))) {
                msg = this.moduleProperties.getProperty(this.getId() + ".postdisable." + best);
            }
            if (msg == null) {
                msg = this.moduleProperties.getProperty(this.getId() + MODULE_POSTDISABLE_PROPERTY);
            }
            if (msg != null) {
                msgStream.println(msg);
            }
        }
        return results;
    }
}

