/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.spring.trust;

import java.io.IOException;
import java.io.InputStream;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.spring.factory.AbstractComponentAwareFactoryBean;
import org.opensaml.security.x509.PKIXTrustEvaluator;
import org.opensaml.security.x509.PKIXValidationInformationResolver;
import org.opensaml.security.x509.X509Support;
import org.opensaml.security.x509.impl.BasicPKIXValidationInformation;
import org.opensaml.security.x509.impl.BasicX509CredentialNameEvaluator;
import org.opensaml.security.x509.impl.CertPathPKIXTrustEvaluator;
import org.opensaml.security.x509.impl.CertPathPKIXValidationOptions;
import org.opensaml.security.x509.impl.PKIXX509CredentialTrustEngine;
import org.opensaml.security.x509.impl.StaticPKIXValidationInformationResolver;
import org.opensaml.security.x509.impl.X509CredentialNameEvaluator;
import org.slf4j.Logger;
import org.springframework.beans.FatalBeanException;

public class StaticPKIXFactoryBean
extends AbstractComponentAwareFactoryBean<PKIXX509CredentialTrustEngine> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(StaticPKIXFactoryBean.class);
    @Nullable
    private List<Resource> certificateResources;
    @Nullable
    private List<Resource> crlResources;
    @Nullable
    private Integer verifyDepth;
    @Nullable
    private Set<String> trustedNames;
    private boolean checkNames = true;
    @Nullable
    private PKIXTrustEvaluator trustEvaluator;
    @Nullable
    private X509CredentialNameEvaluator credentialNameEvaluator;

    @Nonnull
    public Class<?> getObjectType() {
        return PKIXX509CredentialTrustEngine.class;
    }

    public void setCertificates(@Nullable List<Resource> certs) {
        this.certificateResources = certs;
    }

    public void setCRLs(@Nullable List<Resource> crls) {
        this.crlResources = crls;
    }

    public void setVerifyDepth(@Nullable Integer depth) {
        this.verifyDepth = depth;
    }

    public void setCheckNames(boolean flag) {
        this.checkNames = flag;
    }

    public void setTrustedNames(@Nullable Collection<String> names) {
        this.trustedNames = names != null ? CollectionSupport.copyToSet(names) : null;
    }

    public void setTrustEvaluator(@Nullable PKIXTrustEvaluator evaluator) {
        this.trustEvaluator = evaluator;
    }

    public void setCredentialNameEvaluator(@Nullable X509CredentialNameEvaluator evaluator) {
        this.credentialNameEvaluator = evaluator;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<X509Certificate> getCertificates() {
        if (this.certificateResources == null) {
            return CollectionSupport.emptyList();
        }
        assert (this.certificateResources != null);
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(this.certificateResources.size());
        assert (this.certificateResources != null);
        for (Resource f : this.certificateResources) {
            try {
                InputStream is = f.getInputStream();
                try {
                    certificates.addAll(X509Support.decodeCertificates((InputStream)is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException | CertificateException e) {
                this.log.error("Could not decode Certificate at {}: {}", (Object)f.getDescription(), (Object)e.getMessage());
                throw new FatalBeanException("Could not decode provided CertificateFile: " + f.getDescription(), (Throwable)e);
            }
        }
        return certificates;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<X509CRL> getCRLs() {
        if (this.crlResources == null) {
            return CollectionSupport.emptyList();
        }
        assert (this.crlResources != null);
        ArrayList<X509CRL> crls = new ArrayList<X509CRL>(this.crlResources.size());
        assert (this.crlResources != null);
        for (Resource crlFile : this.crlResources) {
            try {
                InputStream is = crlFile.getInputStream();
                try {
                    crls.addAll(X509Support.decodeCRLs((InputStream)is));
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException | CRLException e) {
                this.log.error("Could not decode CRL file at {}: {}", (Object)crlFile.getDescription(), (Object)e.getMessage());
                throw new FatalBeanException("Could not decode provided CRL file " + crlFile.getDescription(), (Throwable)e);
            }
        }
        return crls;
    }

    @Nonnull
    protected PKIXX509CredentialTrustEngine doCreateInstance() throws Exception {
        PKIXTrustEvaluator pkixTrustEvaluator;
        BasicPKIXValidationInformation info = new BasicPKIXValidationInformation(this.getCertificates(), this.getCRLs(), this.verifyDepth);
        StaticPKIXValidationInformationResolver resolver = new StaticPKIXValidationInformationResolver(CollectionSupport.singletonList((Object)info), this.trustedNames, this.checkNames);
        Object object = pkixTrustEvaluator = this.trustEvaluator != null ? this.trustEvaluator : new CertPathPKIXTrustEvaluator();
        X509CredentialNameEvaluator credNameEvaluator = this.credentialNameEvaluator != null ? this.credentialNameEvaluator : (this.checkNames ? new BasicX509CredentialNameEvaluator() : null);
        this.validateConfiguration(pkixTrustEvaluator);
        return new PKIXX509CredentialTrustEngine((PKIXValidationInformationResolver)resolver, pkixTrustEvaluator, credNameEvaluator);
    }

    protected void validateConfiguration(@Nonnull PKIXTrustEvaluator pkixTrustEvaluator) throws Exception {
        CertPathPKIXValidationOptions certPathOptions;
        if (CertPathPKIXTrustEvaluator.class.isInstance(pkixTrustEvaluator) && CertPathPKIXValidationOptions.class.isInstance(pkixTrustEvaluator.getPKIXValidationOptions()) && (certPathOptions = (CertPathPKIXValidationOptions)CertPathPKIXValidationOptions.class.cast(pkixTrustEvaluator.getPKIXValidationOptions())).isForceRevocationEnabled() && certPathOptions.isRevocationEnabled() && this.getCRLs().isEmpty() && !Boolean.getBoolean("com.sun.security.enableCRLDP") && !"true".equalsIgnoreCase(StringSupport.trimOrNull((String)Security.getProperty("oscp.enable")))) {
            this.log.error("Certificate revocation checking was force enabled, but no static CRLs were supplied and both CRLDP and OCSP processing is disabled");
            throw new FatalBeanException("Certificate revocation checking was force enabled, but no static CRLs were supplied and both CRLDP and OCSP processing is disabled");
        }
    }
}

