/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.storage.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.storage.impl.ScriptedStorageMappingStrategy;
import net.shibboleth.idp.attribute.resolver.dc.storage.impl.StorageServiceDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.storage.impl.TemplatedSearchBuilder;
import net.shibboleth.idp.attribute.resolver.spring.dc.AbstractDataConnectorParser;
import net.shibboleth.idp.attribute.resolver.spring.dc.impl.CacheConfigParser;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.AttributeSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.spring.ScriptTypeBeanParser;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StorageServiceDataConnectorParser
extends AbstractDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "StorageService");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StorageServiceDataConnectorParser.class);

    @Nullable
    protected Class<StorageServiceDataConnector> getBeanClass(@Nonnull Element element) {
        return StorageServiceDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        String resultCacheBeanID;
        super.doParse(config, parserContext, builder);
        this.log.debug("{} Parsing custom configuration {}", (Object)this.getLogPrefix(), (Object)config);
        V2Parser v2Parser = new V2Parser(config, this.getLogPrefix());
        String searchBuilderID = v2Parser.getBeanSearchBuilderID();
        if (searchBuilderID != null) {
            builder.addPropertyReference("executableSearchBuilder", searchBuilderID);
        } else {
            builder.addPropertyValue("executableSearchBuilder", (Object)v2Parser.createTemplateBuilder());
        }
        String mappingStrategyID = v2Parser.getBeanMappingStrategyID();
        if (mappingStrategyID != null) {
            builder.addPropertyReference("mappingStrategy", mappingStrategyID);
            if (config.hasAttributeNS(null, "generatedAttributeID")) {
                this.log.warn("{} Ignoring generatedAttributeID in favor of explicit mapping strategy", (Object)this.getLogPrefix());
            }
        } else {
            BeanDefinition def = v2Parser.createMappingStrategy(config.getAttributeNS(null, "id"));
            if (def != null) {
                builder.addPropertyValue("mappingStrategy", (Object)def);
                if (config.hasAttributeNS(null, "generatedAttributeID")) {
                    this.log.warn("{} Ignoring generatedAttributeID in favor of <RecordMapping> element", (Object)this.getLogPrefix());
                }
            } else {
                builder.addPropertyValue("generatedAttributeID", (Object)config.getAttributeNS(null, "generatedAttributeID"));
            }
        }
        if (null != (resultCacheBeanID = CacheConfigParser.getBeanResultCacheID(config))) {
            builder.addPropertyReference("resultsCache", resultCacheBeanID);
        } else {
            builder.addPropertyValue("resultsCache", (Object)v2Parser.createCache(parserContext));
        }
        builder.addPropertyReference("storageService", AttributeSupport.ensureAttributeValue((Element)config, null, (String)"storageServiceRef"));
        String noResultIsError = AttributeSupport.getAttributeValue((Element)config, (QName)new QName("noResultIsError"));
        if (noResultIsError != null) {
            builder.addPropertyValue("noResultAnError", (Object)SpringSupport.getStringValueAsBoolean((String)noResultIsError));
        }
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    protected static class V2Parser {
        @Nonnull
        private final Element configElement;
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(V2Parser.class);
        @Nonnull
        @NotEmpty
        private final String logPrefix;

        public V2Parser(@Nonnull Element config, @Nonnull @NotEmpty String prefix) {
            Constraint.isNotNull((Object)config, (String)"StorageService DataConnector element cannot be null");
            this.configElement = config;
            this.logPrefix = prefix;
        }

        @Nullable
        public String getBeanSearchBuilderID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"executableSearchBuilderRef");
        }

        @Nullable
        public BeanDefinition createTemplateBuilder() {
            List contextTemplates = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "ContextTemplate"));
            List keyTemplates = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "KeyTemplate"));
            if (contextTemplates.size() == 0 || keyTemplates.size() == 0) {
                return null;
            }
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.genericBeanDefinition(TemplatedSearchBuilder.class);
            templateBuilder.setInitMethodName("initialize");
            templateBuilder.setDestroyMethodName("destroy");
            String velocityEngineRef = StringSupport.trimOrNull((String)this.configElement.getAttributeNS(null, "templateEngine"));
            if (null == velocityEngineRef) {
                velocityEngineRef = "shibboleth.VelocityEngine";
            }
            templateBuilder.addPropertyReference("velocityEngine", velocityEngineRef);
            if (contextTemplates.size() > 1) {
                this.log.warn("{} A maximum of 1 <ContextTemplate> should be specified; the first one has been used", (Object)this.getLogPrefix());
            } else if (keyTemplates.size() > 1) {
                this.log.warn("{} A maximum of 1 <KeyTemplate> should be specified; the first one has been used", (Object)this.getLogPrefix());
            }
            Element contextTemplate = (Element)contextTemplates.get(0);
            Element keyTemplate = (Element)keyTemplates.get(0);
            if (this.configElement.hasAttributeNS(null, "customObjectRef")) {
                templateBuilder.addPropertyReference("customObject", AttributeSupport.ensureAttributeValue((Element)this.configElement, null, (String)"customObjectRef"));
            }
            templateBuilder.addPropertyValue("contextTemplateText", (Object)contextTemplate.getTextContent());
            templateBuilder.addPropertyValue("keyTemplateText", (Object)keyTemplate.getTextContent());
            return templateBuilder.getBeanDefinition();
        }

        @Nullable
        public String getBeanMappingStrategyID() {
            return AttributeSupport.getAttributeValue((Element)this.configElement, null, (String)"mappingStrategyRef");
        }

        @Nullable
        public BeanDefinition createMappingStrategy(@Nullable String id) {
            List mappings = ElementSupport.getChildElements((Node)this.configElement, (QName)new QName("urn:mace:shibboleth:2.0:resolver", "RecordMapping"));
            if (mappings.size() > 1) {
                this.log.warn("{} A maximum of 1 <RecordMapping> should be specified; the first one has been used", (Object)this.getLogPrefix());
            } else if (mappings.isEmpty()) {
                return null;
            }
            Element mapping = (Element)mappings.get(0);
            assert (mapping != null);
            BeanDefinitionBuilder mapper = ScriptTypeBeanParser.parseScriptType(ScriptedStorageMappingStrategy.class, (Element)mapping);
            if (id != null) {
                mapper.addPropertyValue("logPrefix", (Object)(id + ":"));
            }
            return mapper.getBeanDefinition();
        }

        @Nullable
        public BeanDefinition createCache(@Nonnull ParserContext parserContext) {
            CacheConfigParser parser = new CacheConfigParser(this.configElement);
            return parser.createCache();
        }

        @Nonnull
        @NotEmpty
        private String getLogPrefix() {
            return this.logPrefix;
        }
    }
}

