/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc.saml.impl;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.dc.saml.impl.SimpleAggregationSAMLDataConnector;
import net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl.ContextAuthorityEntityIDResolver;
import net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl.CriteriaSelfEntityIDResolver;
import net.shibboleth.idp.attribute.resolver.dc.saml.plugin.impl.DependencyAttributeSubjectResolver;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.AttributeAuthorityEntityIDReference;
import net.shibboleth.idp.attribute.resolver.dc.saml.util.impl.AttributeAuthorityEntityIDValue;
import net.shibboleth.idp.attribute.resolver.spring.dc.saml.impl.AbstractSAMLDataConnectorParser;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleAggregationSAMLDataConnectorParser
extends AbstractSAMLDataConnectorParser {
    @Nonnull
    public static final QName TYPE_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "SimpleAggregationSAML");
    @Nonnull
    private static final Map<String, AbstractSAMLDataConnectorParser.CustomPropertyDef> CUSTOM_PROPERTY_DEFS = new HashMap<String, AbstractSAMLDataConnectorParser.CustomPropertyDef>();
    private static final QName ENTITY;
    private static final QName ENTITY_REF;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SimpleAggregationSAMLDataConnectorParser.class);

    public SimpleAggregationSAMLDataConnectorParser() {
        this.resolveAndStoreCustomProperties(CUSTOM_PROPERTY_DEFS);
    }

    @Nullable
    protected Class<SimpleAggregationSAMLDataConnector> getBeanClass(@Nonnull Element element) {
        return SimpleAggregationSAMLDataConnector.class;
    }

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        super.doParse(config, parserContext, builder);
        this.log.debug("{} Parsing XML configuration {}", (Object)this.getLogPrefix(), (Object)config);
        builder.addPropertyValue("queryConnector", (Object)this.parseSAMLDataConnector(config, parserContext));
        ManagedList entityIDSources = new ManagedList();
        for (Element child : ElementSupport.getChildElements((Node)config)) {
            String value;
            assert (child != null);
            QName childName = QNameSupport.getNodeQName((Node)child);
            if (ENTITY.equals(childName)) {
                value = StringSupport.trimOrNull((String)ElementSupport.getElementContentAsString((Element)child));
                if (value == null) continue;
                entityIDSources.add((Object)new AttributeAuthorityEntityIDValue(value));
                continue;
            }
            if (!ENTITY_REF.equals(childName) || (value = StringSupport.trimOrNull((String)ElementSupport.getElementContentAsString((Element)child))) == null) continue;
            entityIDSources.add((Object)new AttributeAuthorityEntityIDReference(value));
        }
        this.log.debug("{} Saw {} total entityID sources: {}", new Object[]{this.getLogPrefix(), entityIDSources.size(), entityIDSources});
        builder.addPropertyValue("entityIDSources", (Object)entityIDSources);
        builder.setInitMethodName("initialize");
        builder.setDestroyMethodName("destroy");
    }

    @Override
    @Nonnull
    protected BeanDefinition getAuthorityEntityIDStrategy(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder strategyBuilder = BeanDefinitionBuilder.genericBeanDefinition(ContextAuthorityEntityIDResolver.class);
        return strategyBuilder.getBeanDefinition();
    }

    @Override
    @Nonnull
    protected BeanDefinition getSelfEntityIDStrategy(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        BeanDefinitionBuilder strategyBuilder = BeanDefinitionBuilder.genericBeanDefinition(CriteriaSelfEntityIDResolver.class);
        this.addCustomProperties(strategyBuilder, "selfEntityIDResolver");
        strategyBuilder.setInitMethodName("initialize");
        strategyBuilder.setDestroyMethodName("destroy");
        return strategyBuilder.getBeanDefinition();
    }

    @Override
    @Nonnull
    protected BeanDefinition getSubjectStrategy(@Nonnull Element config, @Nonnull ParserContext parserContext) {
        String refValue;
        BeanDefinitionBuilder strategyBuilder = BeanDefinitionBuilder.genericBeanDefinition(DependencyAttributeSubjectResolver.class);
        Attr subjectAttributeIDs = config.getAttributeNodeNS(null, "subjectAttributeIDs");
        if (subjectAttributeIDs != null) {
            strategyBuilder.addPropertyValue("attributeIDs", (Object)SpringSupport.getAttributeValueAsList((Attr)subjectAttributeIDs));
        }
        if (config.hasAttributeNS(null, "subjectNameIDFormatMapRef") && (refValue = StringSupport.trimOrNull((String)config.getAttributeNS(null, "subjectNameIDFormatMapRef"))) != null) {
            strategyBuilder.addPropertyReference("nameIDFormatMap", refValue);
        }
        if (config.hasAttributeNS(null, "subjectDefaultNameIDFormat")) {
            strategyBuilder.addPropertyValue("defaultNameIDFormat", (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, "subjectDefaultNameIDFormat")));
        }
        strategyBuilder.setInitMethodName("initialize");
        strategyBuilder.setDestroyMethodName("destroy");
        return strategyBuilder.getBeanDefinition();
    }

    static {
        CUSTOM_PROPERTY_DEFS.put("selfEntityIDResolver", new AbstractSAMLDataConnectorParser.CustomPropertyDef(SimpleAggregationSAMLDataConnectorParser.class, "SelfEntityIDResolver", "bean", true, true));
        ENTITY = new QName("urn:mace:shibboleth:2.0:resolver", "Entity");
        ENTITY_REF = new QName("urn:mace:shibboleth:2.0:resolver", "EntityReference");
    }
}

