/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.spring.dc;

import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.idp.attribute.resolver.spring.BaseResolverPluginParser;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.slf4j.Logger;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDataConnectorParser
extends BaseResolverPluginParser {
    @Nonnull
    public static final QName ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "DataConnector");
    @Nonnull
    @NotEmpty
    public static final String ATTR_NORETRYDELAY = "noRetryDelay";
    @Nonnull
    @NotEmpty
    public static final String ATTR_EXPORT_NAMES = "exportAttributes";
    @Nonnull
    @NotEmpty
    public static final String ATTR_FAIL_FAST = "failFastInitialize";
    @Nonnull
    public static final Boolean FAIL_FAST_DEFAULT = false;
    @Nonnull
    public static final QName FAILOVER_DATA_CONNECTOR_ELEMENT_NAME = new QName("urn:mace:shibboleth:2.0:resolver", "FailoverDataConnector");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractDataConnectorParser.class);

    @Override
    protected void doParse(@Nonnull Element config, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder builder) {
        Attr export;
        super.doParse(config, parserContext, builder);
        List failoverConnector = ElementSupport.getChildElements((Node)config, (QName)FAILOVER_DATA_CONNECTOR_ELEMENT_NAME);
        if (failoverConnector != null && !failoverConnector.isEmpty()) {
            if (failoverConnector.size() > 1) {
                this.log.warn("{} More than one failover data connector specified, taking the first", (Object)this.getLogPrefix());
            }
            String connectorId = StringSupport.trimOrNull((String)((Element)failoverConnector.get(0)).getAttributeNS(null, "ref"));
            this.log.debug("{} Setting the following failover data connector dependencies: {}", (Object)this.getLogPrefix(), (Object)connectorId);
            builder.addPropertyValue("failoverDataConnectorId", (Object)connectorId);
        }
        if (config.hasAttributeNS(null, ATTR_NORETRYDELAY)) {
            builder.addPropertyValue(ATTR_NORETRYDELAY, (Object)StringSupport.trimOrNull((String)config.getAttributeNS(null, ATTR_NORETRYDELAY)));
        }
        if ((export = config.getAttributeNodeNS(null, ATTR_EXPORT_NAMES)) != null) {
            builder.addPropertyValue(ATTR_EXPORT_NAMES, (Object)SpringSupport.getAttributeValueAsList((Attr)export));
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        StringBuilder builder = new StringBuilder("Data Connector '").append(this.getDefinitionId()).append("':");
        String result = builder.toString();
        assert (result != null);
        return result;
    }
}

