/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.transcoding;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.transcoding.AbstractAttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.saml.xmlobject.ScopedValue;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBase64Binary;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObject;
import org.slf4j.Logger;

public abstract class AbstractSAMLAttributeTranscoder<AttributeType extends SAMLObject, EncodedType extends IdPAttributeValue>
extends AbstractAttributeTranscoder<AttributeType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractSAMLAttributeTranscoder.class);

    @Nullable
    public AttributeType doEncode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull Class<? extends AttributeType> to, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        String attributeId = attribute.getId();
        this.log.trace("Beginning to encode attribute {}", (Object)attributeId);
        ArrayList<XMLObject> samlAttributeValues = new ArrayList<XMLObject>();
        for (IdPAttributeValue o : attribute.getValues()) {
            if (o == null) {
                this.log.debug("Skipping null value of attribute {}", (Object)attributeId);
                continue;
            }
            if (!this.canEncodeValue(attribute, o)) {
                this.log.warn("Skipping value of attribute '{}'; Type {} cannot be encoded by this encoder ({}).", new Object[]{attributeId, o.getClass().getSimpleName(), ((Object)((Object)this)).getClass().getSimpleName()});
                continue;
            }
            IdPAttributeValue attributeValue = o;
            XMLObject samlAttributeValue = this.encodeValue(profileRequestContext, attribute, rule, attributeValue);
            if (samlAttributeValue == null) {
                this.log.debug("Skipping null value for attribute {}", (Object)attributeId);
                continue;
            }
            samlAttributeValues.add(samlAttributeValue);
        }
        this.log.trace("Encoded {} values for attribute {}", (Object)samlAttributeValues.size(), (Object)attributeId);
        return this.buildAttribute(profileRequestContext, attribute, to, rule, samlAttributeValues);
    }

    @Nullable
    public IdPAttribute doDecode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull AttributeType input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        String attributeName = this.getEncodedName(rule);
        this.log.trace("Beginning to decode attribute {}", (Object)attributeName);
        ArrayList<IdPAttributeValue> idpAttributeValues = new ArrayList<IdPAttributeValue>();
        Iterable<XMLObject> samlAttributeValues = this.getValues(input);
        for (XMLObject o : samlAttributeValues) {
            if (o == null) {
                this.log.debug("Skipping null value of attribute {}", (Object)attributeName);
                continue;
            }
            IdPAttributeValue idpAttributeValue = this.decodeValue(profileRequestContext, input, rule, o);
            if (idpAttributeValue == null) {
                this.log.debug("Unable to decode value of attribute {}", (Object)attributeName);
                continue;
            }
            idpAttributeValues.add(idpAttributeValue);
        }
        if (!idpAttributeValues.isEmpty()) {
            this.log.trace("Decoded {} values for attribute {}", (Object)idpAttributeValues.size(), (Object)attributeName);
        }
        return this.buildIdPAttribute(profileRequestContext, input, rule, idpAttributeValues);
    }

    @Nullable
    protected String getStringValue(@Nullable XMLObject object) {
        String retVal = null;
        if (object instanceof XSString) {
            XSString val = (XSString)object;
            retVal = val.getValue();
        } else if (object instanceof XSURI) {
            XSURI val = (XSURI)object;
            retVal = val.getURI();
        } else if (object instanceof XSBoolean) {
            Boolean flag;
            XSBoolean val = (XSBoolean)object;
            XSBooleanValue bval = val.getValue();
            if (bval != null && (flag = bval.getValue()) != null) {
                retVal = flag != false ? "1" : "0";
            }
        } else if (object instanceof XSInteger) {
            XSInteger val = (XSInteger)object;
            Integer ival = val.getValue();
            if (ival != null) {
                retVal = ival.toString();
            }
        } else if (object instanceof XSDateTime) {
            XSDateTime val = (XSDateTime)object;
            Instant dt = val.getValue();
            retVal = dt != null ? DOMTypeSupport.instantToString((Instant)dt) : null;
        } else if (object instanceof XSBase64Binary) {
            XSBase64Binary val = (XSBase64Binary)object;
            retVal = val.getValue();
        } else if (object instanceof ScopedValue) {
            ScopedValue val = (ScopedValue)object;
            retVal = val.getValue();
        } else if (object instanceof XSAny) {
            XSAny val = (XSAny)object;
            retVal = val.getUnknownAttributes().isEmpty() && val.getUnknownXMLObjects().isEmpty() ? val.getTextContent() : null;
        }
        if (null == retVal) {
            this.log.info("Value of type {} could not be converted", (Object)(object != null ? object.getClass().getSimpleName() : "(null)"));
        }
        return retVal;
    }

    protected abstract boolean canEncodeValue(@Nonnull IdPAttribute var1, @Nonnull IdPAttributeValue var2);

    @Nonnull
    protected abstract AttributeType buildAttribute(@Nullable ProfileRequestContext var1, @Nullable IdPAttribute var2, @Nonnull Class<? extends AttributeType> var3, @Nonnull TranscodingRule var4, @Nonnull List<XMLObject> var5) throws AttributeEncodingException;

    @Nullable
    protected abstract XMLObject encodeValue(@Nullable ProfileRequestContext var1, @Nonnull IdPAttribute var2, @Nonnull TranscodingRule var3, @Nonnull EncodedType var4) throws AttributeEncodingException;

    @Nonnull
    protected abstract IdPAttribute buildIdPAttribute(@Nullable ProfileRequestContext var1, @Nonnull AttributeType var2, @Nonnull TranscodingRule var3, @Nonnull List<IdPAttributeValue> var4) throws AttributeDecodingException;

    @Nonnull
    protected abstract Iterable<XMLObject> getValues(@Nonnull AttributeType var1);

    @Nullable
    protected abstract IdPAttributeValue decodeValue(@Nullable ProfileRequestContext var1, @Nonnull AttributeType var2, @Nonnull TranscodingRule var3, @Nullable XMLObject var4);
}

