/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.cryptacular.generator.IdGenerator;
import org.cryptacular.generator.RandomIdGenerator;

public class TicketIdentifierGenerationStrategy
implements IdentifierGenerationStrategy {
    @Nonnull
    private final IdGenerator idGenerator;
    @Nonnull
    @NotEmpty
    private String ticketPrefix;
    @Nullable
    private String ticketSuffix;
    @Positive
    private int ticketLength;

    public TicketIdentifierGenerationStrategy(@Nonnull @ParameterName(name="prefix") @NotEmpty String prefix, @ParameterName(name="randomLength") @Positive int randomLength) {
        this.ticketLength = Constraint.isGreaterThan((int)0, (int)randomLength, (String)"Random length must be positive");
        this.ticketPrefix = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)prefix), (String)"Prefix cannot be null or empty");
        Constraint.isTrue((boolean)TicketIdentifierGenerationStrategy.isUrlSafe(this.ticketPrefix), (String)("Unsupported prefix " + this.ticketPrefix));
        this.idGenerator = new RandomIdGenerator(this.ticketLength);
    }

    public void setSuffix(@Nullable String suffix) {
        String s = StringSupport.trimOrNull((String)suffix);
        if (s != null) {
            Constraint.isTrue((boolean)TicketIdentifierGenerationStrategy.isUrlSafe(s), (String)("Unsupported suffix " + s));
            this.ticketSuffix = s;
        }
    }

    @Nonnull
    public String generateIdentifier() {
        StringBuilder builder = new StringBuilder(this.ticketLength * 2);
        builder.append(this.ticketPrefix).append('-');
        builder.append(System.currentTimeMillis()).append('-');
        builder.append(this.idGenerator.generate());
        if (this.ticketSuffix != null) {
            builder.append('-').append(this.ticketSuffix);
        }
        String result = builder.toString();
        assert (result != null);
        return result;
    }

    @Nonnull
    public String generateIdentifier(boolean xmlSafe) {
        return this.generateIdentifier();
    }

    private static boolean isUrlSafe(@Nonnull String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.US_ASCII.name()).equals(s);
        }
        catch (Exception e) {
            return false;
        }
    }
}

