/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultServiceComparator
implements Comparator<String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultServiceComparator.class);
    @Nonnull
    private final Pattern[] ignoredPatterns;
    private boolean caseSensitive;

    public DefaultServiceComparator() {
        this("jsessionid");
    }

    public DefaultServiceComparator(String ... parameterNames) {
        Constraint.isNotNull((Object)parameterNames, (String)"Parameters names cannot be null");
        this.ignoredPatterns = new Pattern[parameterNames.length];
        for (int i = 0; i < parameterNames.length; ++i) {
            this.ignoredPatterns[i] = Pattern.compile(";" + parameterNames[i] + "(?:=[^;/]+)?", 2);
        }
    }

    public void setCaseSensitive(boolean flag) {
        this.caseSensitive = flag;
    }

    @Override
    public int compare(String a, String b) {
        if (a == null || b == null) {
            if (a == null && b == null) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            return 1;
        }
        if (this.caseSensitive) {
            return this.stripPathParameters(a).compareTo(this.stripPathParameters(b));
        }
        return this.stripPathParameters(a).compareToIgnoreCase(this.stripPathParameters(b));
    }

    private String stripPathParameters(@Nonnull String uriString) {
        try {
            URI uri = new URI(uriString);
            String path = uri.getPath();
            for (Pattern pattern : this.ignoredPatterns) {
                Matcher m = pattern.matcher(path);
                path = m.replaceAll("");
            }
            return new URI(uri.getScheme(), uri.getAuthority(), path, uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            this.log.warn("Error parsing {}", (Object)uriString);
            return uriString;
        }
    }
}

