/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.protocol;

import javax.annotation.Nonnull;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;

public enum ProtocolError {
    BrokenProxyChain("INVALID_TICKET", "E_BROKEN_PROXY_CHAIN"),
    IllegalState("INTERNAL_ERROR", "E_ILLEGAL_STATE"),
    InvalidTicketFormat("INVALID_TICKET", "E_INVALID_TICKET_FORMAT"),
    InvalidTicketType("INVALID_TICKET", "E_INVALID_TICKET_TYPE"),
    ProtocolViolation("INVALID_REQUEST", "E_PROTOCOL_VIOLATION"),
    ProxyCallbackAuthenticationFailure("INVALID_REQUEST", "E_PROXY_CALLBACK_AUTH_FAILURE"),
    ProxyNotAuthorized("INVALID_REQUEST", "E_PROXY_NOT_AUTHORIZED"),
    RenewIncompatibleWithProxy("INVALID_REQUEST", "E_RENEW_INCOMPATIBLE_WITH_PROXY"),
    ServiceNotSpecified("INVALID_REQUEST", "E_SERVICE_NOT_SPECIFIED"),
    ServiceMismatch("INVALID_SERVICE", "E_SERVICE_MISMATCH"),
    SessionExpired("INVALID_TICKET", "E_SESSION_EXPIRED"),
    SessionRetrievalError("INVALID_TICKET", "E_SESSION_RETRIEVAL_ERROR"),
    TicketNotSpecified("INVALID_REQUEST", "E_TICKET_NOT_SPECIFIED"),
    TicketExpired("INVALID_TICKET", "E_TICKET_EXPIRED"),
    TicketNotFromRenew("INVALID_TICKET", "E_TICKET_NOT_FROM_RENEW"),
    TicketCreationError("INTERNAL_ERROR", "E_TICKET_CREATION_ERROR"),
    TicketRetrievalError("INTERNAL_ERROR", "E_TICKET_RETRIEVAL_ERROR"),
    TicketRemovalError("INTERNAL_ERROR", "E_TICKET_REMOVAL_ERROR");

    @Nonnull
    private final String errorCode;
    @Nonnull
    private final String errorDetailCode;

    private ProtocolError(String code, String detailCode) {
        this.errorCode = code;
        this.errorDetailCode = detailCode;
    }

    @Nonnull
    public String getCode() {
        return this.errorCode;
    }

    @Nonnull
    public String getDetailCode() {
        return this.errorDetailCode;
    }

    @Nonnull
    public Event event(@Nonnull Object source) {
        LocalAttributeMap attributes = new LocalAttributeMap();
        attributes.put("code", (Object)this.errorCode);
        attributes.put("detailCode", (Object)this.errorDetailCode);
        return new Event(source, this.name(), (AttributeMap)attributes);
    }
}

