/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.config;

import java.security.Principal;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.config.AuthenticationProfileConfiguration;
import net.shibboleth.idp.cas.config.AbstractProtocolConfiguration;
import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class LoginConfiguration
extends AbstractProtocolConfiguration
implements AuthenticationProfileConfiguration {
    @Nonnull
    @NotEmpty
    public static final String PROFILE_ID = "https://www.apereo.org/cas/protocol/login";
    @Nonnull
    @NotEmpty
    public static final String PROFILE_COUNTER = "net.shibboleth.idp.profiles.cas.login";
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TICKET_PREFIX = "ST";
    public static final int DEFAULT_TICKET_LENGTH = 25;
    @Nonnull
    private Function<ProfileRequestContext, Set<String>> authenticationFlowsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> postAuthenticationFlowsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Function<ProfileRequestContext, Collection<Principal>> defaultAuthenticationContextsLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> forceAuthnPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Duration> maxAgeLookupStrategy = FunctionSupport.constant(null);
    @Nonnull
    private Predicate<ProfileRequestContext> storeConsentInTicketsPredicate = PredicateSupport.alwaysFalse();
    @Nonnull
    private Function<ProfileRequestContext, Integer> proxyCountLookupStrategy = FunctionSupport.constant(null);

    public LoginConfiguration() {
        super(PROFILE_ID);
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<Principal> getDefaultAuthenticationMethods(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<Principal> methods = this.defaultAuthenticationContextsLookupStrategy.apply(profileRequestContext);
        if (methods != null) {
            return CollectionSupport.copyToList(methods);
        }
        return CollectionSupport.emptyList();
    }

    public void setDefaultAuthenticationMethods(@Nullable Collection<Principal> contexts) {
        this.defaultAuthenticationContextsLookupStrategy = contexts != null ? FunctionSupport.constant((Object)CollectionSupport.copyToList(contexts)) : FunctionSupport.constant(null);
    }

    public void setDefaultAuthenticationMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<Principal>> strategy) {
        this.defaultAuthenticationContextsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    @Nonnull
    @NotLive
    @Unmodifiable
    public Set<String> getAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Set<String> flows = this.authenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToSet(flows);
        }
        return CollectionSupport.emptySet();
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    public void setAuthenticationFlows(@Nullable Collection<String> flows) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"setAuthenticationFlows", (String)"relying-party.xml", (String)"setDefaultAuthenticationMethods");
        this.authenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(Set.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    public void setAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<String>> strategy) {
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"setAuthenticationFlowsLookupStrategy", (String)"relying-party.xml", (String)"setDefaultAuthenticationMethodsLookupStrategy");
        this.authenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public List<String> getPostAuthenticationFlows(@Nullable ProfileRequestContext profileRequestContext) {
        Collection<String> flows = this.postAuthenticationFlowsLookupStrategy.apply(profileRequestContext);
        if (flows != null) {
            return CollectionSupport.copyToList(flows);
        }
        return CollectionSupport.emptyList();
    }

    public void setPostAuthenticationFlows(@Nullable Collection<String> flows) {
        this.postAuthenticationFlowsLookupStrategy = flows != null ? FunctionSupport.constant(List.copyOf(StringSupport.normalizeStringCollection(flows))) : FunctionSupport.constant(null);
    }

    public void setPostAuthenticationFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.postAuthenticationFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public boolean isForceAuthn(@Nullable ProfileRequestContext profileRequestContext) {
        return this.forceAuthnPredicate.test(profileRequestContext);
    }

    public void setForceAuthn(boolean flag) {
        this.forceAuthnPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setForceAuthnPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.forceAuthnPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Forced authentication predicate cannot be null");
    }

    @ConfigurationSetting(name="maxAge")
    @Nullable
    public Duration getMaxAge(@Nullable ProfileRequestContext profileRequestContext) {
        return this.maxAgeLookupStrategy.apply(profileRequestContext);
    }

    public void setMaxAge(@Nullable Duration maxAge) {
        this.maxAgeLookupStrategy = FunctionSupport.constant((Object)maxAge);
    }

    public void setMaxAgeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        this.maxAgeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @ConfigurationSetting(name="storeConsentInTickets")
    public boolean isStoreConsentInTickets(@Nullable ProfileRequestContext profileRequestContext) {
        return this.storeConsentInTicketsPredicate.test(profileRequestContext);
    }

    public void setStoreConsentInTickets(boolean flag) {
        this.storeConsentInTicketsPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setStoreConsentInTicketsPredicate(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.storeConsentInTicketsPredicate = (Predicate)Constraint.isNotNull(condition, (String)"Condition cannot be null");
    }

    @Nullable
    public Integer getProxyCount(@Nullable ProfileRequestContext profileRequestContext) {
        Integer count = this.proxyCountLookupStrategy.apply(profileRequestContext);
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        return count;
    }

    public void setProxyCount(@Nullable @NonNegative Integer count) {
        if (count != null) {
            Constraint.isGreaterThanOrEqual((int)0, (int)count, (String)"Proxy count must be greater than or equal to 0");
        }
        this.proxyCountLookupStrategy = FunctionSupport.constant((Object)count);
    }

    public void setProxyCountLookupStrategy(@Nonnull Function<ProfileRequestContext, Integer> strategy) {
        this.proxyCountLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    @Override
    @Nonnull
    @NotEmpty
    protected String getDefaultTicketPrefix() {
        return DEFAULT_TICKET_PREFIX;
    }

    @Override
    protected int getDefaultTicketLength() {
        return 25;
    }
}

