/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.attribute;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.AttributeDecodingException;
import net.shibboleth.idp.attribute.AttributeEncodingException;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.transcoding.AbstractAttributeTranscoder;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.cas.attribute.Attribute;
import net.shibboleth.idp.cas.attribute.CASAttributeTranscoder;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractCASAttributeTranscoder<EncodedType extends IdPAttributeValue>
extends AbstractAttributeTranscoder<Attribute>
implements CASAttributeTranscoder {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractCASAttributeTranscoder.class);

    @Nonnull
    public Class<Attribute> getEncodedType() {
        return Attribute.class;
    }

    @Nullable
    public String getEncodedName(@Nonnull TranscodingRule rule) {
        String name = (String)rule.getOrDefault("cas.name", String.class, (Object)((String)rule.get("id", String.class)));
        if (name != null) {
            return new NamingFunction().apply(new Attribute(name));
        }
        return null;
    }

    @Nullable
    public Attribute doEncode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull Class<? extends Attribute> to, @Nonnull TranscodingRule rule) throws AttributeEncodingException {
        String attributeId = attribute.getId();
        this.log.trace("Beginning to encode attribute {}", (Object)attributeId);
        String name = this.getEncodedName(profileRequestContext, attribute, rule);
        Attribute casAttribute = new Attribute(name);
        for (IdPAttributeValue o : attribute.getValues()) {
            if (o == null) {
                this.log.debug("Skipping null value of attribute {}", (Object)attributeId);
                continue;
            }
            if (!this.canEncodeValue(attribute, o)) {
                this.log.warn("Skipping value of attribute '{}'; Type {} cannot be encoded by this encoder ({}).", new Object[]{attributeId, o.getClass().getSimpleName(), this.getClass().getSimpleName()});
                continue;
            }
            IdPAttributeValue attributeValue = o;
            String casAttributeValue = this.encodeValue(profileRequestContext, attribute, rule, attributeValue);
            if (casAttributeValue == null) {
                this.log.debug("Skipping null value for attribute {}", (Object)attributeId);
                continue;
            }
            casAttribute.getValues().add(casAttributeValue);
        }
        if (!attribute.getValues().isEmpty() && casAttribute.getValues().isEmpty()) {
            throw new AttributeEncodingException("Failed to encode any values for attribute " + attribute.getId());
        }
        this.log.trace("Encoded {} values for attribute {}", (Object)casAttribute.getValues().size(), (Object)attributeId);
        return casAttribute;
    }

    @Nullable
    public IdPAttribute doDecode(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute input, @Nonnull TranscodingRule rule) throws AttributeDecodingException {
        String attributeName = this.getEncodedName(rule);
        this.log.trace("Beginning to decode attribute {}", (Object)attributeName);
        ArrayList<IdPAttributeValue> idpAttributeValues = new ArrayList<IdPAttributeValue>();
        for (String o : input.getValues()) {
            if (o == null) {
                this.log.debug("Skipping null value of attribute {}", (Object)attributeName);
                continue;
            }
            IdPAttributeValue idpAttributeValue = this.decodeValue(profileRequestContext, input, rule, o);
            if (idpAttributeValue == null) {
                this.log.debug("Unable to decode value of attribute {}", (Object)attributeName);
                continue;
            }
            idpAttributeValues.add(idpAttributeValue);
        }
        if (!idpAttributeValues.isEmpty()) {
            this.log.trace("Decoded {} values for attribute {}", (Object)idpAttributeValues.size(), (Object)attributeName);
        }
        return this.buildIdPAttribute(profileRequestContext, input, rule, idpAttributeValues);
    }

    @Nonnull
    protected String getEncodedName(@Nullable ProfileRequestContext profileRequestContext, @Nonnull IdPAttribute attribute, @Nonnull TranscodingRule rule) {
        String tagValue;
        Boolean useMetadata = (Boolean)rule.getOrDefault("cas.nameFromMetadata", Boolean.class, (Object)false);
        if (useMetadata != null && useMetadata.booleanValue() && (tagValue = StringSupport.trimOrNull((String)this.getNameFromMetadata(profileRequestContext, attribute.getId()))) != null) {
            return tagValue;
        }
        String staticName = (String)rule.getOrDefault("cas.name", String.class, (Object)attribute.getId());
        assert (staticName != null);
        return staticName;
    }

    protected abstract boolean canEncodeValue(@Nonnull IdPAttribute var1, @Nonnull IdPAttributeValue var2);

    @Nullable
    protected abstract String encodeValue(@Nullable ProfileRequestContext var1, @Nonnull IdPAttribute var2, @Nonnull TranscodingRule var3, @Nonnull EncodedType var4) throws AttributeEncodingException;

    @Nonnull
    protected IdPAttribute buildIdPAttribute(@Nullable ProfileRequestContext profileRequestContext, @Nonnull Attribute attribute, @Nonnull TranscodingRule rule, @Nonnull List<IdPAttributeValue> attributeValues) throws AttributeDecodingException {
        String id = (String)rule.get("id", String.class);
        if (Strings.isNullOrEmpty((String)id)) {
            throw new AttributeDecodingException("Required transcoder property 'id' not found");
        }
        assert (id != null);
        if (!attribute.getValues().isEmpty() && attributeValues.isEmpty()) {
            throw new AttributeDecodingException("Failed to decode any values for attribute " + attribute.getName());
        }
        IdPAttribute idpAttribute = new IdPAttribute(id);
        idpAttribute.setValues(attributeValues);
        return idpAttribute;
    }

    @Nullable
    protected abstract IdPAttributeValue decodeValue(@Nullable ProfileRequestContext var1, @Nonnull Attribute var2, @Nonnull TranscodingRule var3, @Nullable String var4);

    public static class NamingFunction
    implements Function<Attribute, String> {
        @Override
        @Nullable
        public String apply(@Nullable Attribute input) {
            if (input == null || input.getName() == null) {
                return null;
            }
            return "CAS:" + input.getName();
        }
    }
}

