/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.webflow.execution.RequestContext;

public class LogSpringContextInfo
extends AbstractProfileAction
implements ApplicationContextAware {
    @Nonnull
    @NotEmpty
    public static final String ATTRIB_DESC = "springInfoDescription";
    @Nonnull
    private Logger log = LoggerFactory.getLogger((String)"SPRING_CONTEXT_INFO");
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private String description;

    public void setDescription(@Nullable String value) {
        this.description = StringSupport.trimOrNull((String)value);
    }

    public void setApplicationContext(@Nonnull ApplicationContext context) throws BeansException {
        this.applicationContext = context;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        String contextualDescription = null;
        SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
        if (springRequestContext != null && springRequestContext.getRequestContext() != null) {
            RequestContext requestContext = springRequestContext.getRequestContext();
            assert (requestContext != null);
            contextualDescription = requestContext.getAttributes().getString(ATTRIB_DESC);
        }
        if (contextualDescription == null) {
            contextualDescription = this.description;
        }
        if (contextualDescription != null) {
            this.log.debug("Spring ApplicationContext hierarchy contextual description: {}", (Object)contextualDescription);
        }
        this.log.debug("**********************************************************************************************");
        for (ApplicationContext current = this.applicationContext; current != null; current = current.getParent()) {
            this.log.debug("Spring Context: {}", (Object)current.toString());
            this.log.debug("Spring Context Name: {}", (Object)current.getApplicationName());
            this.log.debug("Spring Context Parent: {}", (Object)current.getParent());
            this.log.debug("");
            this.log.debug("Spring Context Bean Definition Count: {}", (Object)current.getBeanDefinitionCount());
            this.log.debug("");
            this.log.debug("Spring Context Bean Details:");
            this.log.debug("");
            for (String beanName : current.getBeanDefinitionNames()) {
                assert (beanName != null);
                Class type = current.getType(beanName);
                assert (type != null);
                this.log.debug(String.format("Spring Bean id: %s, singleton?: %s, prototype?: %s, type: %s", beanName, current.isSingleton(beanName), current.isPrototype(beanName), type.getName()));
            }
            this.log.debug("**********************************************************************************************");
        }
    }
}

