/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.impl;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.ScratchContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@ThreadSafe
public final class InitializeProfileRequestContext
extends AbstractProfileAction {
    @Nullable
    private String profileId;
    @Nullable
    private String legacyProfileId;
    @Nullable
    private String loggingId;
    private boolean browserProfile;
    private boolean captureQueryParameters;

    public void setProfileId(@Nullable String id) {
        this.checkSetterPreconditions();
        this.profileId = StringSupport.trimOrNull((String)id);
    }

    public void setLegacyProfileId(@Nullable String id) {
        this.checkSetterPreconditions();
        this.legacyProfileId = StringSupport.trimOrNull((String)id);
    }

    public void setLoggingId(@Nullable String id) {
        this.checkSetterPreconditions();
        this.loggingId = StringSupport.trimOrNull((String)id);
    }

    public void setBrowserProfile(boolean browser) {
        this.checkSetterPreconditions();
        this.browserProfile = browser;
    }

    public void setCaptureQueryParameters(boolean flag) {
        this.checkSetterPreconditions();
        this.captureQueryParameters = flag;
    }

    @Nullable
    public Event execute(@Nullable RequestContext springRequestContext) {
        HttpServletRequest request;
        assert (springRequestContext != null);
        this.checkComponentActive();
        ProfileRequestContext prc = new ProfileRequestContext();
        if (this.profileId != null) {
            prc.setProfileId(this.profileId);
        }
        if (this.legacyProfileId != null) {
            prc.setLegacyProfileId(this.legacyProfileId);
        }
        if (this.loggingId != null) {
            prc.setLoggingId(this.loggingId);
        }
        prc.setBrowserProfile(this.browserProfile);
        springRequestContext.getConversationScope().put("opensamlProfileRequestContext", (Object)prc);
        if (this.captureQueryParameters && (request = this.getHttpServletRequest()) != null) {
            ((ScratchContext)prc.ensureSubcontext(ScratchContext.class)).getMap().putAll(request.getParameterMap());
        }
        return ActionSupport.buildProceedEvent((Object)((Object)this));
    }
}

