/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile.audit.impl;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.profile.context.AuditContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateAuditContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateAuditContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AuditContext> auditContextCreationStrategy = new ChildContextLookup(AuditContext.class, true);
    @Nonnull
    private Map<String, Function<ProfileRequestContext, Object>> fieldExtractors = CollectionSupport.emptyMap();
    @Nonnull
    private Set<String> fieldsToExtract = CollectionSupport.emptySet();
    @Nonnull
    private Map<String, String> fieldReplacements = CollectionSupport.emptyMap();
    @Nonnull
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_INSTANT;
    private boolean useDefaultTimeZone;
    private boolean clearAuditContext;
    @NonnullBeforeExec
    private AuditContext auditCtx;

    public void setAuditContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AuditContext> strategy) {
        this.checkSetterPreconditions();
        this.auditContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuditContext creation strategy cannot be null");
    }

    public void setFieldExtractors(@Nonnull Map<String, Function<ProfileRequestContext, Object>> map) {
        this.checkSetterPreconditions();
        Constraint.isNotNull(map, (String)"Field extractor map cannot be null");
        this.fieldExtractors = new HashMap<String, Function<ProfileRequestContext, Object>>(map.size());
        for (Map.Entry<String, Function<ProfileRequestContext, Object>> entry : map.entrySet()) {
            String field = StringSupport.trimOrNull((String)entry.getKey());
            if (entry.getValue() == null) continue;
            this.fieldExtractors.put(field, entry.getValue());
        }
    }

    public void setFormattingMapParser(@Nonnull FormattingMapParser parser) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)parser, (String)"Parsed audit formatting map cannot be null");
        this.fieldsToExtract = parser.getFieldsToExtract();
    }

    public void setFieldReplacements(@Nullable Map<String, String> map) {
        this.checkSetterPreconditions();
        this.fieldReplacements = map != null ? new HashMap<String, String>(map) : CollectionSupport.emptyMap();
    }

    public void setDateTimeFormat(@Nullable @NotEmpty String format) {
        this.checkSetterPreconditions();
        if (format != null) {
            this.dateTimeFormatter = DateTimeFormatter.ofPattern(StringSupport.trimOrNull((String)format));
        }
    }

    public void setUseDefaultTimeZone(boolean flag) {
        this.checkSetterPreconditions();
        this.useDefaultTimeZone = flag;
    }

    public void setClearAuditContext(boolean flag) {
        this.checkSetterPreconditions();
        this.clearAuditContext = flag;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.dateTimeFormatter = this.useDefaultTimeZone ? this.dateTimeFormatter.withZone(ZoneId.systemDefault()) : this.dateTimeFormatter.withZone(ZoneOffset.UTC);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.auditCtx = this.auditContextCreationStrategy.apply(profileRequestContext);
        if (this.auditCtx == null) {
            this.log.error("{} Unable to create AuditContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.clearAuditContext) {
            this.auditCtx.getFields().clear();
        }
        for (Map.Entry<String, Function<ProfileRequestContext, Object>> entry : this.fieldExtractors.entrySet()) {
            String key = entry.getKey();
            assert (key != null);
            if (!this.fieldsToExtract.isEmpty() && !this.fieldsToExtract.contains(key)) {
                this.log.trace("{} Skipping field '{}' not included in audit format", (Object)this.getLogPrefix(), (Object)entry.getKey());
                continue;
            }
            Object values = entry.getValue().apply(profileRequestContext);
            if (values == null) continue;
            if (values instanceof Collection) {
                if (((Collection)values).isEmpty()) continue;
                this.log.trace("{} Adding {} value(s) for field '{}'", new Object[]{this.getLogPrefix(), ((Collection)values).size(), entry.getKey()});
                for (Object value : (Collection)values) {
                    this.addField(key, value);
                }
                continue;
            }
            this.log.trace("{} Adding 1 value for field '{}'", (Object)this.getLogPrefix(), (Object)entry.getKey());
            this.addField(key, values);
        }
    }

    private void addField(@Nonnull @NotEmpty String key, @Nullable Object value) {
        assert (this.isPreExecuteCalled());
        if (value != null) {
            if (value instanceof TemporalAccessor) {
                this.auditCtx.getFieldValues(key).add(this.dateTimeFormatter.format((TemporalAccessor)value));
            } else {
                String s = value.toString();
                if (this.fieldReplacements.containsKey(s)) {
                    s = this.fieldReplacements.get(s);
                }
                if (s != null) {
                    this.auditCtx.getFieldValues(key).add(s);
                }
            }
        }
    }

    public static class FormattingMapParser {
        @Nonnull
        private final Set<String> fields;

        public FormattingMapParser(@Nonnull Map<String, String> map) {
            HashSet<String> fieldsToExtract = new HashSet<String>(10);
            for (String s : map.values()) {
                int len = s.length();
                boolean inToken = false;
                StringBuilder field = new StringBuilder();
                for (int pos = 0; pos < len; ++pos) {
                    char ch = s.charAt(pos);
                    if (inToken) {
                        if (!Character.isLetterOrDigit(ch) && ch != '-' && ch != '%') {
                            fieldsToExtract.add(field.substring(1));
                            field.setLength(0);
                            inToken = false;
                        }
                    } else if (ch == '%') {
                        field.setLength(0);
                        inToken = true;
                    }
                    field.append(ch);
                }
                if (field.length() <= 0 || !inToken) continue;
                fieldsToExtract.add(field.substring(1));
            }
            this.fields = CollectionSupport.copyToSet(fieldsToExtract);
        }

        @Nonnull
        @NotLive
        @Unmodifiable
        public Set<String> getFieldsToExtract() {
            return this.fields;
        }
    }
}

