/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver.context.navigate;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractAttributeResolutionLookupFunction<Type>
implements ContextDataLookupFunction<ProfileRequestContext, Type> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAttributeResolutionLookupFunction.class);
    @Nonnull
    private Function<BaseContext, AttributeResolutionContext> attributeResolutionContextLookupStrategy = new RecursiveTypedChildContextLookup(AttributeResolutionContext.class);

    public void setAttributeResolutionContextLookupStrategy(@Nonnull Function<BaseContext, AttributeResolutionContext> strategy) {
        this.attributeResolutionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeResolutionContext lookup strategy cannot be null");
    }

    @Nullable
    public Type apply(@Nullable ProfileRequestContext input) {
        AttributeResolutionContext arc;
        if (input != null && (arc = this.attributeResolutionContextLookupStrategy.apply((BaseContext)input)) != null) {
            if (arc.containsSubcontext(AttributeResolverWorkContext.class)) {
                return this.doApply(arc);
            }
            this.log.warn("Located AttributeResolutionContext with no work context below it, ignoring");
        }
        return null;
    }

    @Nullable
    protected abstract Type doApply(@Nonnull AttributeResolutionContext var1);
}

