/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.resolver.AbstractResolverPlugin;
import net.shibboleth.idp.attribute.resolver.AttributeDefinition;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolverWorkContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

@ThreadSafe
public abstract class AbstractAttributeDefinition
extends AbstractResolverPlugin<IdPAttribute>
implements AttributeDefinition {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractAttributeDefinition.class);
    private boolean dependencyOnly;
    private boolean preRequested;
    @Nullable
    private String logPrefix;

    @Override
    public boolean isDependencyOnly() {
        return this.dependencyOnly;
    }

    public void setDependencyOnly(boolean isDependencyOnly) {
        this.checkSetterPreconditions();
        this.dependencyOnly = isDependencyOnly;
    }

    @Override
    public boolean isPreRequested() {
        return this.preRequested;
    }

    public void setPreRequested(boolean value) {
        this.checkSetterPreconditions();
        this.preRequested = value;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.logPrefix = null;
        if (IdPAttribute.isInvalidId((String)this.getId())) {
            throw new ComponentInitializationException("Invalid Attribute Definitions name (" + this.getId() + ")");
        }
        if (IdPAttribute.isDeprecatedId((String)this.ensureId())) {
            DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.CONFIGURATION, (String)"Use of AttributeDefinition id with invalid characters", (String)this.getLogPrefix(), null);
            this.log.debug("{} Deprecated characters in AttributeDefintion id", (Object)this.getLogPrefix());
        }
    }

    @Override
    @Nullable
    protected IdPAttribute doResolve(@Nonnull AttributeResolutionContext resolutionContext, @Nonnull AttributeResolverWorkContext workContext) throws ResolutionException {
        IdPAttribute resolvedAttribute = this.doAttributeDefinitionResolve(resolutionContext, workContext);
        if (null == resolvedAttribute) {
            this.log.debug("{} no attribute was produced during resolution", (Object)this.getLogPrefix());
            return null;
        }
        if (resolvedAttribute.getValues().isEmpty()) {
            this.log.debug("{} produced an attribute with no values", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} produced an attribute with the following values {}", (Object)this.getLogPrefix(), (Object)resolvedAttribute.getValues());
        }
        return resolvedAttribute;
    }

    @Nullable
    protected abstract IdPAttribute doAttributeDefinitionResolve(@Nonnull AttributeResolutionContext var1, @Nonnull AttributeResolverWorkContext var2) throws ResolutionException;

    @Override
    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Definition '").append(this.getId()).append("':");
            prefix = builder.toString();
            assert (prefix != null);
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        assert (prefix != null);
        return prefix;
    }
}

