/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.installablecomponent.InstallableComponentSupport;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.slf4j.Logger;

public class InstallableComponentPropertyCache
extends AbstractIdentifiableInitializableComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InstallableComponentPropertyCache.class);
    @Nonnull
    private final Map<URL, Pair<Instant, Properties>> cache = new HashMap<URL, Pair<Instant, Properties>>();
    @NonnullAfterInit
    private Duration cacheLife;
    @Nonnull
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);

    public void setCacheLife(@Nullable Duration howLong) {
        this.cacheLife = (Duration)Constraint.isNotNull((Object)howLong, (String)"Duration cache life should be non null");
        assert (howLong != null);
        Constraint.isTrue((!howLong.isNegative() ? 1 : 0) != 0, (String)"Duration cache life should be positive");
        this.log.debug("Setting a delay of {} minutes", (Object)this.cacheLife.toMinutes());
    }

    protected void doInitialize() throws ComponentInitializationException {
        if (this.cacheLife == null) {
            throw new ComponentInitializationException("Cache life was not specified was null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Properties loadInfo(@Nonnull List<URL> updateURLs, @Nonnull HttpClient client, @Nullable HttpClientSecurityParameters securityParameters) {
        Pair<Instant, Properties> cachedValue;
        this.log.trace("Looking for '{}'", updateURLs);
        if (updateURLs.isEmpty() || this.cacheLife.isZero()) {
            this.log.trace("No Key or zero cachelife");
            return InstallableComponentSupport.loadInfo(updateURLs, (HttpClient)client, (HttpClientSecurityParameters)securityParameters);
        }
        Lock readLock = this.readWriteLock.readLock();
        try {
            readLock.lock();
            Instant now = Instant.now();
            cachedValue = this.cache.get(updateURLs.get(0));
            if (cachedValue != null) {
                this.log.trace("Cache hit: [expires: {} now: {}]", cachedValue.getFirst(), (Object)now);
                Instant ts = (Instant)cachedValue.getFirst();
                if (ts != null && ts.isAfter(now)) {
                    Properties properties = (Properties)cachedValue.getSecond();
                    return properties;
                }
            }
        }
        finally {
            readLock.unlock();
        }
        this.log.trace("Cached entry not found or was out of date.");
        Lock writeLock = this.readWriteLock.readLock();
        try {
            writeLock.lock();
            cachedValue = this.cache.get(updateURLs.get(0));
            Instant now = Instant.now();
            if (cachedValue != null) {
                this.log.trace("Cache hit: [expires: {} now: {}]", cachedValue.getFirst(), (Object)now);
                Instant ts = (Instant)cachedValue.getFirst();
                if (ts != null && ts.isAfter(now)) {
                    Properties properties = (Properties)cachedValue.getSecond();
                    return properties;
                }
            }
            Properties result = InstallableComponentSupport.loadInfo(updateURLs, (HttpClient)client, (HttpClientSecurityParameters)securityParameters);
            Instant expires = now.plus(this.cacheLife);
            this.log.trace("Caching entry with{} data [expires: {}]", (Object)(result == null ? "out" : ""), (Object)expires);
            this.cache.put(updateURLs.get(0), (Pair<Instant, Properties>)new Pair((Object)expires, (Object)result));
            Properties properties = result;
            return properties;
        }
        finally {
            writeLock.unlock();
        }
    }
}

