/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.admin.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.admin.AdministrativeFlowDescriptor;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.ui.context.RelyingPartyUIContext;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.spring.util.SpringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class InitializeAdministrativeProfileContextTree
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeAdministrativeProfileContextTree.class);
    @NonnullBeforeExec
    private AdministrativeFlowDescriptor flowDescriptor;
    @Nullable
    private List<String> fallbackLanguages;

    public void setAdministrativeFlowDescriptor(@Nullable AdministrativeFlowDescriptor descriptor) {
        this.checkSetterPreconditions();
        this.flowDescriptor = descriptor;
    }

    public void setFallbackLanguages(@Nonnull List<String> langs) {
        this.checkSetterPreconditions();
        this.fallbackLanguages = langs != null ? List.copyOf(langs) : null;
    }

    @Nonnull
    private AdministrativeFlowDescriptor getFlowDescriptor() {
        assert (this.isPreExecuteCalled());
        return this.flowDescriptor;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        AdministrativeFlowDescriptor descriptor = this.flowDescriptor;
        if (descriptor == null) {
            this.log.warn("{} Administrative profile '{}' not enabled", (Object)this.getLogPrefix(), (Object)profileRequestContext.getProfileId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        String id = descriptor.getId();
        if (id == null || !id.equals(profileRequestContext.getProfileId())) {
            this.log.warn("{} Profile ID '{}' doesn't match descriptor ID '{}", new Object[]{this.getLogPrefix(), profileRequestContext.getProfileId(), id});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} Profile ID '{}' No HttpRequestSupplier available", (Object)this.getLogPrefix(), (Object)profileRequestContext.getProfileId());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        profileRequestContext.setLoggingId(this.getFlowDescriptor().getLoggingId());
        profileRequestContext.setBrowserProfile(!this.getFlowDescriptor().isNonBrowserSupported(profileRequestContext));
        RelyingPartyContext rpCtx = new RelyingPartyContext();
        profileRequestContext.addSubcontext((BaseContext)rpCtx, true);
        rpCtx.setRelyingPartyId(this.getFlowDescriptor().getId());
        rpCtx.setProfileConfig((ProfileConfiguration)this.getFlowDescriptor());
        RelyingPartyUIContext uiCtx = (RelyingPartyUIContext)rpCtx.ensureSubcontext(RelyingPartyUIContext.class);
        uiCtx.setRPUInfo(this.getFlowDescriptor().getUIInfo());
        NonnullSupplier supplier = this.getHttpServletRequestSupplier();
        assert (supplier != null);
        uiCtx.setBrowserLanguageRanges(SpringSupport.getLanguageRange((HttpServletRequest)((HttpServletRequest)supplier.get())));
        uiCtx.setRequestSupplier(supplier);
        if (null != this.fallbackLanguages) {
            uiCtx.setFallbackLanguages(this.fallbackLanguages);
        }
    }
}

