/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.config.logic;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.saml.saml2.profile.config.ECPProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.CurrentOrPreviousEventLookup;
import org.slf4j.Logger;

public class SOAPErrorPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SOAPErrorPredicate.class);
    @Nonnull
    private Function<ProfileRequestContext, EventContext> eventContextLookupStrategy = new CurrentOrPreviousEventLookup();

    public void setEventContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EventContext> strategy) {
        this.eventContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EventContext lookup strategy cannot be null");
    }

    public boolean test(@Nullable ProfileRequestContext input) {
        Object event;
        RelyingPartyContext rpCtx = this.getRelyingPartyContext(input);
        if (rpCtx == null) {
            this.log.debug("No RelyingPartyContext found, assuming error handled with SOAP fault");
            return true;
        }
        EventContext eventCtx = this.eventContextLookupStrategy.apply(input);
        Object object = event = eventCtx != null ? eventCtx.getEvent() : null;
        if (event == null) {
            this.log.debug("No event found, assuming error handled with SOAP fault");
            return true;
        }
        ProfileConfiguration pc = rpCtx.getProfileConfig();
        if (!(pc instanceof ECPProfileConfiguration)) {
            this.log.debug("No ECP profile configuration found, assuming error handled with SOAP fault");
            return true;
        }
        String eventString = event.toString();
        if (((ECPProfileConfiguration)pc).getLocalEvents(input).contains(eventString)) {
            this.log.debug("Error event {} will be handled locally", (Object)eventString);
            return false;
        }
        this.log.debug("Error event {} will be handled with SOAP fault", (Object)eventString);
        return true;
    }
}

