/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.saml.profile.config.logic;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.saml.profile.config.SAMLAssertionProducingProfileConfiguration;
import net.shibboleth.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.saml.saml1.profile.config.ArtifactResolutionProfileConfiguration;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;

public class SignAssertionsPredicate
extends AbstractRelyingPartyPredicate {
    private boolean honorMetadata = true;
    @Nonnull
    private Function<ProfileRequestContext, SAMLMetadataContext> metadataContextLookupStrategy = new SAMLMetadataContextLookupFunction();

    public void setHonorMetadata(boolean flag) {
        this.honorMetadata = flag;
    }

    public void setMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLMetadataContext> strategy) {
        this.metadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SAMLMetadataContext lookup strategy cannot be null");
    }

    public boolean test(@Nullable ProfileRequestContext input) {
        Boolean flag;
        RoleDescriptor role;
        SAMLMetadataContext metadataCtx;
        if (this.honorMetadata && (metadataCtx = this.metadataContextLookupStrategy.apply(input)) != null && (role = metadataCtx.getRoleDescriptor()) instanceof SPSSODescriptor && (flag = ((SPSSODescriptor)role).getWantAssertionsSigned()) != null && flag.booleanValue()) {
            return true;
        }
        RelyingPartyContext rpc = this.getRelyingPartyContext(input);
        if (rpc != null) {
            ProfileConfiguration pc = rpc.getProfileConfig();
            if (pc instanceof SAMLAssertionProducingProfileConfiguration) {
                SAMLAssertionProducingProfileConfiguration downcast = (SAMLAssertionProducingProfileConfiguration)pc;
                return downcast.isSignAssertions(input);
            }
            if (pc instanceof net.shibboleth.saml.saml2.profile.config.ArtifactResolutionProfileConfiguration) {
                net.shibboleth.saml.saml2.profile.config.ArtifactResolutionProfileConfiguration downcast = (net.shibboleth.saml.saml2.profile.config.ArtifactResolutionProfileConfiguration)pc;
                return downcast.isSignAssertions(input);
            }
            if (pc instanceof ArtifactResolutionProfileConfiguration) {
                ArtifactResolutionProfileConfiguration downcast = (ArtifactResolutionProfileConfiguration)pc;
                return downcast.isSignAssertions(input);
            }
        }
        return false;
    }
}

