/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.flow.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.flow.impl.AbstractCASProtocolAction;
import net.shibboleth.idp.cas.service.Service;
import net.shibboleth.idp.cas.session.impl.CASSPSession;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.idp.session.SPSession;
import net.shibboleth.idp.session.SessionException;
import net.shibboleth.idp.session.SessionResolver;
import net.shibboleth.idp.session.criterion.SessionIdCriterion;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.action.EventException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class UpdateIdPSessionWithSPSessionAction<RequestType, ResponseType>
extends AbstractCASProtocolAction<RequestType, ResponseType> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UpdateIdPSessionWithSPSessionAction.class);
    @Nonnull
    private final SessionResolver sessionResolver;
    @Nonnull
    private final Duration sessionLifetime;
    @Nonnull
    private Function<ProfileRequestContext, String> relyingPartyIdLookupStrategy;
    @NonnullBeforeExec
    private Ticket ticket;
    @NonnullBeforeExec
    private Service service;

    public UpdateIdPSessionWithSPSessionAction(@Nonnull SessionResolver resolver, @Nonnull Duration lifetime) {
        this.sessionResolver = (SessionResolver)Constraint.isNotNull((Object)resolver, (String)"Session resolver cannot be null");
        this.sessionLifetime = (Duration)Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
        this.relyingPartyIdLookupStrategy = new RelyingPartyIdLookupFunction();
    }

    public void setRelyingPartyIdLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.relyingPartyIdLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingParty ID lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.service = this.getCASService(profileRequestContext);
            if (!this.service.isSingleLogoutParticipant()) {
                return false;
            }
            this.ticket = this.getCASTicket(profileRequestContext);
        }
        catch (EventException e) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)e.getEventID());
            return false;
        }
        if (this.ticket.getSessionId() == null) {
            this.log.debug("{} Cannot update IdP session because the ticket is not bound to a session", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        IdPSession session = null;
        try {
            this.log.debug("{} Attempting to retrieve session {}", (Object)this.getLogPrefix(), (Object)this.ticket.getSessionId());
            session = (IdPSession)this.sessionResolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new SessionIdCriterion((String)Constraint.isNotNull((Object)this.ticket.getSessionId(), (String)"Null Session Id"))}));
        }
        catch (ResolverException e) {
            this.log.warn("{} Possible sign of misconfiguration, IdPSession resolution error: {}", (Object)this.getLogPrefix(), (Object)e);
        }
        if (session != null) {
            Instant now = Instant.now();
            assert (now != null);
            Instant expiration = now.plus(this.sessionLifetime);
            assert (expiration != null);
            String relyingPartyId = this.relyingPartyIdLookupStrategy.apply(profileRequestContext);
            CASSPSession sps = new CASSPSession(relyingPartyId != null ? relyingPartyId : this.ticket.getService(), now, expiration, this.ticket.getId(), this.ticket.getService());
            this.log.debug("{} Created SP session {}", (Object)this.getLogPrefix(), (Object)sps);
            try {
                session.addSPSession((SPSession)sps);
            }
            catch (SessionException e) {
                this.log.warn("{} Failed updating IdPSession with CASSPSession", (Object)this.getLogPrefix(), (Object)e);
            }
        } else {
            this.log.info("{} Cannot store CASSPSession since IdPSession not found", (Object)this.getLogPrefix());
        }
    }
}

