/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.service.reloadable;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.service.ServiceableComponent;
import org.slf4j.Logger;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ApplicationContext;

public class ReloadableScope
implements Scope {
    @Nonnull
    @NotEmpty
    public static final String SCOPE_RELOADABLE = "reloadable";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ReloadableScope.class);
    @Nonnull
    private final ReloadableService<ApplicationContext> reloadableService;

    public ReloadableScope(@Nonnull @ParameterName(name="service") ReloadableService<ApplicationContext> service) {
        this.reloadableService = (ReloadableService)Constraint.isNotNull(service, (String)"ReloadableService cannot be null");
    }

    @Nonnull
    public Object get(@Nonnull String name, @Nonnull ObjectFactory<?> objectFactory) {
        this.log.debug("Accessing reloadable bean instance '{}'", (Object)name);
        ServiceableComponent<ApplicationContext> component = this.reloadableService.getServiceableComponent();
        try {
            Object object = component.getComponent().getBean(name);
            if (component != null) {
                component.close();
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (component != null) {
                    try {
                        component.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ServiceException e) {
                throw new IllegalStateException("Reloadable bean context is unavailable", e);
            }
        }
    }

    public Object remove(@Nonnull String name) {
        throw new UnsupportedOperationException("No support for object removal");
    }

    public void registerDestructionCallback(@Nonnull String name, @Nonnull Runnable callback) {
        this.log.warn("Ignoring unsupported destruction callback for '{}'", (Object)name);
    }

    @Nullable
    public Object resolveContextualObject(@Nonnull String key) {
        return null;
    }

    @Nullable
    public String getConversationId() {
        return null;
    }
}

