/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.context;

import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeSupport;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.DeprecationSupport;
import org.opensaml.messaging.context.BaseContext;

@NotThreadSafe
public final class AttributeContext
extends BaseContext {
    @Nonnull
    private Map<String, IdPAttribute> attributes;
    @Nonnull
    private Map<String, IdPAttribute> unfilteredAttributes = CollectionSupport.emptyMap();
    private boolean consented;

    public AttributeContext() {
        this.attributes = CollectionSupport.emptyMap();
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getIdPAttributes() {
        return this.attributes;
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    @Nonnull
    public AttributeContext setIdPAttributes(@Nullable Collection<IdPAttribute> newAttributes) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setIdPAttributes(Collection)", (String)"AttributeContext", (String)"setIdPAttributes(Map)");
        return this.setIdPAttributes(IdPAttributeSupport.toMapNoDuplicates(newAttributes));
    }

    @Nonnull
    public AttributeContext setIdPAttributes(@Nullable Map<String, IdPAttribute> newAttributes) {
        this.attributes = newAttributes != null ? CollectionSupport.copyToMap(newAttributes) : CollectionSupport.emptyMap();
        return this;
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public Map<String, IdPAttribute> getUnfilteredIdPAttributes() {
        return this.unfilteredAttributes;
    }

    @Deprecated(since="5.2.0", forRemoval=true)
    @Nonnull
    public AttributeContext setUnfilteredIdPAttributes(@Nullable Collection<IdPAttribute> newAttributes) {
        DeprecationSupport.warn((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setUnfilteredIdPAttributes(Collection)", (String)"AttributeContext", (String)"setUnfilteredIdPAttributes(Map)");
        return this.setUnfilteredIdPAttributes(IdPAttributeSupport.toMapNoDuplicates(newAttributes));
    }

    @Nonnull
    public AttributeContext setUnfilteredIdPAttributes(@Nullable Map<String, IdPAttribute> newAttributes) {
        this.unfilteredAttributes = newAttributes != null ? CollectionSupport.copyToMap(newAttributes) : CollectionSupport.emptyMap();
        return this;
    }

    public boolean isConsented() {
        return this.consented;
    }

    @Nonnull
    public AttributeContext setConsented(boolean flag) {
        this.consented = flag;
        return this;
    }
}

