/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.config;

import java.time.Duration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.spring.config.StringToDurationConverter;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.springframework.core.convert.converter.Converter;

public class DurationConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<Duration> {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(DurationConfigurationLookupStrategy.class);
    @Nonnull
    private final Converter<String, Duration> durationConverter = new StringToDurationConverter();

    @Override
    @Nullable
    protected Duration doTranslate(@Nonnull IdPAttribute tag) {
        List<IdPAttributeValue> values = tag.getValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getId());
            return null;
        }
        LOG.debug("Converting tag '{}' to Duration property", (Object)tag.getId());
        IdPAttributeValue value = values.get(0);
        if (value instanceof StringAttributeValue) {
            try {
                return (Duration)this.durationConverter.convert((Object)((StringAttributeValue)value).getValue());
            }
            catch (IllegalArgumentException e) {
                LOG.error("Error converting duration", (Throwable)e);
                return null;
            }
        }
        LOG.error("Tag '{}' contained non-string value, returning null");
        return null;
    }

    @Override
    @Nullable
    protected Duration doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            LOG.error("Tag '{}' contained multiple values, returning none", (Object)tag.getName());
            return null;
        }
        LOG.debug("Converting tag '{}' to Duration property", (Object)tag.getName());
        XMLObject value = (XMLObject)values.get(0);
        assert (value != null);
        return this.xmlObjectToDuration(value);
    }

    @Nullable
    private Duration xmlObjectToDuration(@Nonnull XMLObject object) {
        XSAny val;
        if (object instanceof XSString) {
            XSString val2 = (XSString)object;
            String value = val2.getValue();
            if (value != null) {
                try {
                    return (Duration)this.durationConverter.convert((Object)value);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Error converting duration", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        if (object instanceof XSInteger) {
            XSInteger val3 = (XSInteger)object;
            Integer value = val3.getValue();
            return value != null ? Duration.ofMillis(value.longValue()) : null;
        }
        if (object instanceof XSAny && (val = (XSAny)object).getUnknownAttributes().isEmpty() && val.getUnknownXMLObjects().isEmpty()) {
            String value = val.getTextContent();
            if (value != null) {
                try {
                    return (Duration)this.durationConverter.convert((Object)value);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Error converting duration", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        LOG.error("Unsupported conversion to Duration from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

