/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cli;

import com.beust.jcommander.JCommander;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.cli.CommandLineArguments;
import net.shibboleth.shared.annotation.constraint.NotEmpty;

public final class CLI {
    @Nonnull
    @NotEmpty
    public static final String ARGS_PROPERTY = "net.shibboleth.idp.cli.arguments";

    private CLI() {
    }

    public static void main(@Nonnull String[] args) throws ReflectiveOperationException, SecurityException, IllegalArgumentException {
        String msg;
        String argType = System.getProperty(ARGS_PROPERTY);
        if (argType == null) {
            CLI.errorAndExit("net.shibboleth.idp.cli.arguments system property not set", null);
        }
        CommandLineArguments argObject = null;
        try {
            Constructor<?> construct = Class.forName(argType).getConstructor(new Class[0]);
            Object obj = construct.newInstance(new Object[0]);
            if (!(obj instanceof CommandLineArguments)) {
                CLI.errorAndExit("Argument class was not of the correct type", null);
            }
            argObject = (CommandLineArguments)obj;
            JCommander jc = new JCommander((Object)argObject);
            jc.parse(args);
            if (argObject.isUsage()) {
                jc.usage();
                return;
            }
        }
        catch (ClassNotFoundException e) {
            CLI.errorAndExit("Argument class " + argType + " not found ", null);
        }
        catch (IllegalAccessException | InstantiationException e) {
            msg = e.getMessage();
            assert (msg != null);
            CLI.errorAndExit(msg, null);
        }
        assert (argObject != null);
        try {
            argObject.validate();
        }
        catch (IllegalArgumentException e) {
            msg = e.getMessage();
            assert (msg != null);
            CLI.errorAndExit(msg, null);
        }
        CLI.doRequest(argObject);
    }

    private static void doRequest(@Nonnull CommandLineArguments args) {
        URL url = null;
        HttpURLConnection connection = null;
        try {
            Map<String, String> headers;
            String authorization;
            url = args.buildURL();
            connection = (HttpURLConnection)url.openConnection();
            if (args.getMethod() != null) {
                connection.setRequestMethod(args.getMethod());
            }
            if ((authorization = args.getBasicAuthHeader()) != null) {
                connection.setRequestProperty("Authorization", authorization);
            }
            if ((headers = args.getHeaders()) != null) {
                for (Map.Entry<String, String> h : headers.entrySet()) {
                    connection.setRequestProperty(h.getKey(), h.getValue());
                }
            }
            try (InputStream stream = connection.getInputStream();){
                CLI.outputStream(stream, System.out);
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            String msg = e.getMessage();
            assert (msg != null);
            CLI.errorAndExit(msg, null);
        }
        catch (FileNotFoundException e) {
            CLI.errorAndExit(e.getMessage() + " returned File Not Found error", connection);
        }
        catch (IOException e) {
            CLI.errorAndExit((String)(url != null ? "(" + url.toString() + ") " : "") + e.getMessage(), connection);
        }
    }

    private static void outputStream(@Nonnull InputStream source, @Nonnull PrintStream sink) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(source);
             BufferedReader in = new BufferedReader(reader);){
            String line;
            while ((line = in.readLine()) != null) {
                sink.println(line);
            }
        }
    }

    private static void errorAndExit(@Nonnull String errorMessage, @Nullable HttpURLConnection conn) {
        System.err.println(errorMessage);
        if (conn != null) {
            try (InputStream err = conn.getErrorStream();){
                if (err != null) {
                    CLI.outputStream(err, System.err);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.exit(1);
    }
}

