/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.MoreObjects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.SubjectCanonicalizer;
import net.shibboleth.idp.profile.FlowDescriptor;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class SubjectCanonicalizationFlowDescriptor
extends AbstractIdentifiableInitializableComponent
implements FlowDescriptor,
Predicate<ProfileRequestContext> {
    @NonnullAfterInit
    private String flowId;
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();

    @Nullable
    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(@Nullable String id) {
        this.checkSetterPreconditions();
        Constraint.isFalse((boolean)(this instanceof SubjectCanonicalizer), (String)"Flow ID cannot be set on inline c14n implementation.");
        this.flowId = StringSupport.trimOrNull((String)id);
        if (id != null) {
            Constraint.isTrue((boolean)this.flowId.startsWith("c14n/"), (String)"Flow ID must begin with c14n/ prefix.");
        }
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.flowId == null && !(this instanceof SubjectCanonicalizer)) {
            this.flowId = this.ensureId();
            if (!this.flowId.startsWith("c14n/")) {
                throw new ComponentInitializationException("Defaulted flow ID must begin with c14n/ prefix.");
            }
        }
    }

    @Override
    public boolean test(ProfileRequestContext input) {
        this.checkComponentActive();
        return this.activationCondition.test(input);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof SubjectCanonicalizationFlowDescriptor) {
            SubjectCanonicalizationFlowDescriptor scfd = (SubjectCanonicalizationFlowDescriptor)obj;
            return this.getId().equals(scfd.getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("flowId", (Object)this.getFlowId()).toString();
    }
}

