/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicate;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public abstract class AbstractCredentialValidator
extends AbstractIdentifiedInitializableComponent
implements CredentialValidator,
PrincipalSupportingComponent {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractCredentialValidator.class);
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = PredicateSupport.alwaysTrue();
    @Nullable
    private String logPrefix;
    @Nullable
    private Subject customPrincipals;

    public synchronized void setId(@Nonnull String id) {
        super.setId(id);
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.checkSetterPreconditions();
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition cannot be null");
    }

    @Override
    @Nonnull
    @Unmodifiable
    @NotLive
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        Subject localCopy = this.customPrincipals;
        if (localCopy == null) {
            return CollectionSupport.emptySet();
        }
        Set<T> result = localCopy.getPrincipals(c);
        if (result == null) {
            return CollectionSupport.emptySet();
        }
        return result;
    }

    public void setSupportedPrincipals(@Nullable Collection<Principal> principals) {
        this.checkSetterPreconditions();
        if (principals != null) {
            Set copy = CollectionSupport.copyToSet(principals);
            if (!copy.isEmpty()) {
                this.customPrincipals = new Subject();
                this.customPrincipals.getPrincipals().addAll(copy);
            } else {
                this.customPrincipals = null;
            }
        } else {
            this.customPrincipals = null;
        }
    }

    @Override
    public Subject validate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        this.checkComponentActive();
        if (!this.activationCondition.test(profileRequestContext)) {
            this.log.debug("{} Activation condition was false, ignoring request", (Object)this.getLogPrefix());
            return null;
        }
        if (!this.isAcceptable((RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class), this.customPrincipals, this.ensureId())) {
            return null;
        }
        return this.doValidate(profileRequestContext, authenticationContext, warningHandler, errorHandler);
    }

    @Nullable
    protected abstract Subject doValidate(@Nonnull ProfileRequestContext var1, @Nonnull AuthenticationContext var2, @Nullable CredentialValidator.WarningHandler var3, @Nullable CredentialValidator.ErrorHandler var4) throws Exception;

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        Subject localCopy = this.customPrincipals;
        if (localCopy != null) {
            subject.getPrincipals().addAll(localCopy.getPrincipals());
        }
        return subject;
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = "Credential Validator " + (this.getId() != null ? this.getId() : "(unknown)") + ":";
            return this.logPrefix;
        }
        assert (this.logPrefix != null);
        return this.logPrefix;
    }

    protected boolean isAcceptable(@Nullable RequestedPrincipalContext requestedPrincipalCtx, final @Nullable Subject subject, @Nonnull @NotEmpty String configName) {
        if (subject != null && requestedPrincipalCtx != null) {
            String operator = requestedPrincipalCtx.getOperator();
            if (operator != null) {
                this.log.debug("{} Request contains principal requirements, checking validator '{}' for compatibility", (Object)this.getLogPrefix(), (Object)configName);
                for (Principal p : requestedPrincipalCtx.getRequestedPrincipals()) {
                    PrincipalEvalPredicateFactory factory = requestedPrincipalCtx.getPrincipalEvalPredicateFactoryRegistry().lookup(p.getClass(), operator);
                    if (factory != null) {
                        PrincipalSupportingComponent wrapper;
                        PrincipalEvalPredicate predicate = factory.getPredicate(p);
                        if (predicate.test(wrapper = new PrincipalSupportingComponent(){

                            @Override
                            @Nonnull
                            public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
                                Set<T> principals = subject.getPrincipals(c);
                                assert (principals != null);
                                return principals;
                            }
                        })) {
                            this.log.debug("{} Validator '{}' compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), configName, p.getClass(), requestedPrincipalCtx.getOperator()});
                            requestedPrincipalCtx.setMatchingPrincipal(predicate.getMatchingPrincipal());
                            return true;
                        }
                        this.log.debug("{} Validator '{}' not compatible with principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), configName, p.getClass(), requestedPrincipalCtx.getOperator()});
                        continue;
                    }
                    this.log.debug("{} No comparison logic registered for principal type '{}' and operator '{}'", new Object[]{this.getLogPrefix(), p.getClass(), requestedPrincipalCtx.getOperator()});
                }
            }
            this.log.debug("{} Skipping validator '{}', not compatible with request's principal requirements", (Object)this.getLogPrefix(), (Object)configName);
            return false;
        }
        return true;
    }
}

